/*
 * Decompiled with CFR 0.152.
 */
package uk.co.certait.htmlexporter.writer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.list.GrowthList;

public class RowTracker {
    private Map<Integer, List<String>> rows = new TreeMap<Integer, List<String>>();

    protected void addCell(int rowIndex, int columnIndex, int rowSpan, int columnSpan) {
        this.updateRows(rowIndex, columnIndex, rowSpan, columnSpan);
    }

    protected void updateRows(int rowIndex, int columnIndex, int rowSpan, int columnSpan) {
        for (int i = rowIndex; i < rowIndex + rowSpan; ++i) {
            if (!this.rows.containsKey(i)) {
                List cells = GrowthList.decorate(new ArrayList());
                this.rows.put(i, cells);
            }
            for (int j = columnIndex; j < columnIndex + columnSpan; ++j) {
                List<String> cells = this.rows.get(i);
                if (cells.size() > j) {
                    cells.remove(j);
                }
                String s = "[" + i + "," + j + "]";
                cells.add(j, s);
            }
        }
    }

    public int getNextColumnIndexForRow(int rowIndex) {
        int columnIndex = 0;
        if (this.rows.get(rowIndex) != null) {
            for (String s : this.rows.get(rowIndex)) {
                if (s == null) break;
                ++columnIndex;
            }
        }
        return columnIndex;
    }

    public int getTrackedRowCount() {
        return this.rows.size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Integer i : this.rows.keySet()) {
            builder.append("Row ").append(i).append(":");
            for (String s : this.rows.get(i)) {
                if (s != null) {
                    builder.append(s);
                    continue;
                }
                builder.append("[x,x]");
            }
            builder.append("\n");
        }
        return builder.toString();
    }
}

