/*
 * Decompiled with CFR 0.152.
 */
package uk.co.certait.htmlexporter.writer;

import java.text.NumberFormat;
import java.text.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Element;
import uk.co.certait.htmlexporter.ss.CellRange;
import uk.co.certait.htmlexporter.ss.DefaultTableCellReference;
import uk.co.certait.htmlexporter.ss.Dimension;
import uk.co.certait.htmlexporter.ss.Function;
import uk.co.certait.htmlexporter.ss.RangeReferenceTracker;
import uk.co.certait.htmlexporter.writer.TableCellWriter;

public abstract class AbstractTableCellWriter
implements TableCellWriter {
    private RangeReferenceTracker tracker = new RangeReferenceTracker();

    @Override
    public void writeCell(Element element, int rowIndex, int columnIndex) {
        this.renderCell(element, rowIndex, columnIndex);
        if (this.isFunctionGroupCell(element)) {
            for (String rangeName : this.getFunctionGroupReferences(element)) {
                this.tracker.addCelltoRange(rangeName, new DefaultTableCellReference(rowIndex, columnIndex));
            }
        }
        if (this.isFunctionOutputCell(element)) {
            String rangeName = this.getFunctionOutputReference(element);
            this.addFunctionCell(rowIndex, columnIndex, this.tracker.getCellRange(rangeName), Function.SUM);
        }
    }

    public String getElementText(Element element) {
        String text = element.ownText();
        for (Element child : element.children()) {
            text = child.ownText();
        }
        return text;
    }

    protected boolean spansMultipleColumns(Element element) {
        boolean spansMultipleColumns = false;
        if (element.hasAttr("colspan")) {
            int columnCount = Integer.parseInt(element.attr("colspan"));
            spansMultipleColumns = columnCount > 1;
        }
        return spansMultipleColumns;
    }

    protected boolean definesFreezePane(Element element) {
        boolean definesFreezePane = false;
        if (element.hasAttr("data-freeze-pane-cell") && Boolean.parseBoolean(element.attr("data-freeze-pane-cell"))) {
            definesFreezePane = true;
        }
        return definesFreezePane;
    }

    protected int getMergedColumnCount(Element element) {
        int columnCount = 1;
        if (this.spansMultipleColumns(element)) {
            columnCount = Integer.parseInt(element.attr("colspan"));
        }
        return columnCount;
    }

    protected boolean isFunctionGroupCell(Element element) {
        return element.hasAttr("data-group");
    }

    protected boolean isDateCell(Element element) {
        return element.hasAttr("data-date-cell-format");
    }

    protected String getDateCellFormat(Element element) {
        return element.attr("data-date-cell-format");
    }

    protected boolean isNumericCell(Element element) {
        return this.getNumericValue(element) != null;
    }

    protected boolean isPercentageCell(Element element) {
        return this.getNumericValue(element) != null && element.ownText().trim().endsWith("%");
    }

    protected String[] getFunctionGroupReferences(Element element) {
        return this.getAttributeValues(element, "data-group");
    }

    protected boolean isFunctionOutputCell(Element element) {
        boolean functionOutputCell = false;
        for (Attribute attribute : element.attributes()) {
            if (!attribute.getKey().equalsIgnoreCase("data-group-output")) continue;
            functionOutputCell = true;
            break;
        }
        return functionOutputCell;
    }

    protected String getFunctionOutputReference(Element element) {
        String functionOutputGroup = null;
        for (Attribute attribute : element.attributes()) {
            if (!attribute.getKey().equalsIgnoreCase("data-group-output")) continue;
            functionOutputGroup = attribute.getValue();
            break;
        }
        return functionOutputGroup;
    }

    protected String getCellCommentText(Element element) {
        String commentText = null;
        for (Attribute attribute : element.attributes()) {
            if (!attribute.getKey().equalsIgnoreCase("data-cell-comment")) continue;
            commentText = attribute.getValue();
            break;
        }
        return StringUtils.trimToNull(commentText);
    }

    protected Dimension getCellCommentDimension(Element element) {
        Dimension dimension = null;
        for (Attribute attribute : element.attributes()) {
            if (!attribute.getKey().equalsIgnoreCase("data-cell-comment-dimension")) continue;
            try {
                dimension = new Dimension(attribute.getValue());
            }
            catch (IllegalArgumentException ex) {
                dimension = new Dimension(3, 1);
            }
        }
        return dimension != null ? dimension : new Dimension(3, 1);
    }

    protected String[] getAttributeValues(Element element, String attributeName) {
        String[] values = null;
        if (element.hasAttr(attributeName)) {
            for (String value : values = element.attr(attributeName).toLowerCase().split(",")) {
                value = value.trim().toLowerCase();
            }
        }
        return values;
    }

    public Double getNumericValue(Element element) {
        Double numericValue = null;
        if (!element.hasAttr("data-text-cell")) {
            try {
                numericValue = NumberFormat.getInstance().parse(element.ownText()).doubleValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return numericValue;
    }

    public abstract void renderCell(Element var1, int var2, int var3);

    public abstract void addFunctionCell(int var1, int var2, CellRange var3, Function var4);
}

