/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.util;

import org.jetbrains.annotations.Nullable;
import org.simplejavamail.internal.util.Preconditions;

public class SimpleConversions {
    @Nullable
    public static String convertToString(@Nullable Object value) {
        return value != null ? value.toString() : null;
    }

    @Nullable
    public static Integer convertToInteger(@Nullable Object value) {
        if (value == null || value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        Preconditions.assumeTrue(value instanceof String, "Wrong property must have been requested");
        return Integer.valueOf((String)value);
    }

    @Nullable
    public static Boolean convertToBoolean(@Nullable Object value) {
        if (value == null || value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        Preconditions.assumeTrue(value instanceof String, "Wrong property must have been requested");
        String strValue = (String)value;
        if (strValue.equalsIgnoreCase("true") || strValue.equalsIgnoreCase("1")) {
            return true;
        }
        if (strValue.equalsIgnoreCase("false") || strValue.equalsIgnoreCase("0")) {
            return false;
        }
        throw new IllegalArgumentException("Wrong property must have been requested");
    }
}

