/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.api.internal.clisupport.model;

import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public enum CliBuilderApiType {
    EMAIL("email"),
    MAILER("mailer");

    @NotNull
    private final String paramPrefix;

    private CliBuilderApiType(String paramPrefix) {
        this.paramPrefix = paramPrefix;
    }

    public static Collection<CliBuilderApiType> findForCliSynopsis(String synopsis) {
        HashSet<CliBuilderApiType> foundForSynopsis = new HashSet<CliBuilderApiType>();
        for (CliBuilderApiType builderApiType : CliBuilderApiType.values()) {
            if (!synopsis.matches(String.format(".*--%s:.*", builderApiType.paramPrefix))) continue;
            foundForSynopsis.add(builderApiType);
        }
        return foundForSynopsis;
    }

    @NotNull
    public String getParamPrefix() {
        return this.paramPrefix;
    }
}

