/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.core.io;

import fr.opensagres.xdocreport.core.EncodingConstants;
import fr.opensagres.xdocreport.core.io.IEntryInfo;
import fr.opensagres.xdocreport.core.io.IEntryInputStreamProvider;
import fr.opensagres.xdocreport.core.io.IEntryOutputStreamProvider;
import fr.opensagres.xdocreport.core.io.IEntryReaderProvider;
import fr.opensagres.xdocreport.core.io.IEntryWriterProvider;
import fr.opensagres.xdocreport.core.io.IOUtils;
import fr.opensagres.xdocreport.core.io.internal.OutputStream2InputStream;
import fr.opensagres.xdocreport.core.io.internal.OutputStreamWriterCancelable;
import fr.opensagres.xdocreport.core.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class XDocArchive
implements IEntryInputStreamProvider,
IEntryReaderProvider,
IEntryWriterProvider,
IEntryOutputStreamProvider {
    private static final String MIMETYPE_ENTRY_NAME = "mimetype";
    private Map<String, byte[]> cacheEntries = new LinkedHashMap<String, byte[]>();
    private Map<String, IEntryInfo> cacheEntriesInfo = new LinkedHashMap<String, IEntryInfo>();
    private Map<String, Long> lastModifiedEntries;
    private Map<String, Set<String>> cacheEntriesWilcard = null;

    public XDocArchive() {
        this(false);
    }

    public XDocArchive(boolean trackLastModified) {
        this.lastModifiedEntries = trackLastModified ? new HashMap<String, Long>() : null;
    }

    public Set<String> getEntryNames() {
        return this.cacheEntries.keySet();
    }

    public Set<String> getEntryNames(String wildcard) {
        Set<String> entryNamesWithWildcard;
        if (this.cacheEntriesWilcard == null) {
            this.cacheEntriesWilcard = new HashMap<String, Set<String>>();
        }
        if ((entryNamesWithWildcard = this.cacheEntriesWilcard.get(wildcard)) != null) {
            return entryNamesWithWildcard;
        }
        String regexp = XDocArchive.wildcardToRegex(wildcard);
        entryNamesWithWildcard = new HashSet<String>();
        Set<String> entryNames = this.getEntryNames();
        for (String entryName : entryNames) {
            if (!entryName.matches(regexp)) continue;
            entryNamesWithWildcard.add(entryName);
        }
        this.cacheEntriesWilcard.put(wildcard, entryNamesWithWildcard);
        return entryNamesWithWildcard;
    }

    private static String wildcardToRegex(String wildcard) {
        StringBuilder s = new StringBuilder(wildcard.length());
        s.append('^');
        int is = wildcard.length();
        block5: for (int i = 0; i < is; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    continue block5;
                }
                case '?': {
                    s.append(".");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    continue block5;
                }
                default: {
                    s.append(c);
                }
            }
        }
        s.append('$');
        return s.toString();
    }

    @Override
    public InputStream getEntryInputStream(String entryName) {
        if (!this.cacheEntries.containsKey(entryName)) {
            return null;
        }
        return new ByteArrayInputStream(this.cacheEntries.get(entryName));
    }

    @Override
    public Reader getEntryReader(String entryName) {
        InputStream inputStream = this.getEntryInputStream(entryName);
        if (inputStream == null) {
            return null;
        }
        return XDocArchive.toUTF8Reader(inputStream);
    }

    @Override
    public OutputStream getEntryOutputStream(String entryName) {
        return new EntryByteArrayOutputStream(entryName);
    }

    @Override
    public Writer getEntryWriter(String entryName) {
        return XDocArchive.toUTF8Writer(this.getEntryOutputStream(entryName));
    }

    public XDocArchive createCopy() {
        XDocArchive archiveCopy = new XDocArchive();
        for (Map.Entry<String, byte[]> entry : this.cacheEntries.entrySet()) {
            String name = entry.getKey();
            byte[] entryData = entry.getValue();
            byte[] entryDataCopy = new byte[entryData.length];
            System.arraycopy(entryData, 0, entryDataCopy, 0, entryData.length);
            archiveCopy.cacheEntries.put(name, entryDataCopy);
        }
        return archiveCopy;
    }

    public boolean hasEntry(String entryName) {
        return this.cacheEntries.containsKey(entryName);
    }

    private static Reader toUTF8Reader(InputStream inputStream) {
        return new InputStreamReader(inputStream, EncodingConstants.UTF_8);
    }

    private static Writer toUTF8Writer(OutputStream outputStream) {
        return new OutputStreamWriterCancelable(outputStream, EncodingConstants.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XDocArchive readZip(InputStream sourceStream) throws IOException {
        if (sourceStream == null) {
            throw new IOException("InputStream cannot be null.");
        }
        XDocArchive archive = null;
        try (ZipInputStream zipInputStream = null;){
            zipInputStream = new ZipInputStream(sourceStream);
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (archive == null) {
                    archive = new XDocArchive(true);
                }
                XDocArchive.setEntry(archive, zipEntry.getName(), zipInputStream);
                zipInputStream.closeEntry();
            }
        }
        if (archive == null) {
            throw new IOException("InputStream is not a zip.");
        }
        return archive;
    }

    public static void setEntry(XDocArchive archive, String entryName, InputStream input) throws IOException {
        if (entryName.indexOf("\\") != -1) {
            entryName = StringUtils.replaceAll(entryName, "\\", "/");
        }
        OutputStream output = archive.getEntryOutputStream(entryName);
        IOUtils.copy(input, output);
        output.close();
    }

    public static void writeEntry(XDocArchive archive, String entryName, OutputStream outputStream) throws IOException {
        if (!archive.hasEntry(entryName)) {
            throw new IOException("Cannot find entry name=" + entryName + " in the document archive.");
        }
        outputStream.write(archive.cacheEntries.get(entryName));
    }

    public static void writeZip(XDocArchive archive, OutputStream outputStream) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        Set<String> entryNames = archive.getEntryNames();
        XDocArchive.writeZipEntry(zipOutputStream, archive, MIMETYPE_ENTRY_NAME, 0);
        for (String entryName : entryNames) {
            if (MIMETYPE_ENTRY_NAME.equals(entryName)) continue;
            XDocArchive.writeZipEntry(zipOutputStream, archive, entryName, 8);
        }
        zipOutputStream.close();
    }

    private static void writeZipEntry(ZipOutputStream zipOutputStream, XDocArchive archive, String entryName, int method) throws IOException {
        InputStream entryInputStream = archive.getEntryInputStream(entryName);
        if (entryInputStream == null) {
            return;
        }
        ZipEntry zipEntry = new ZipEntry(entryName);
        zipEntry.setMethod(method);
        if (method == 0) {
            byte[] inputBytes = IOUtils.toByteArray(entryInputStream);
            CRC32 crc = new CRC32();
            crc.update(inputBytes);
            zipEntry.setCrc(crc.getValue());
            zipEntry.setSize(inputBytes.length);
            zipEntry.setCompressedSize(inputBytes.length);
            zipOutputStream.putNextEntry(zipEntry);
            IOUtils.write(inputBytes, (OutputStream)zipOutputStream);
        } else {
            zipOutputStream.putNextEntry(zipEntry);
            IOUtils.copy(entryInputStream, (OutputStream)zipOutputStream);
        }
        IOUtils.closeQuietly(entryInputStream);
        zipOutputStream.closeEntry();
    }

    public static InputStream getInputStream(XDocArchive archive) throws IOException {
        OutputStream2InputStream outputArchiveZipped = new OutputStream2InputStream();
        XDocArchive.writeZip(archive, outputArchiveZipped);
        return outputArchiveZipped.getInputStream();
    }

    private boolean isTrackLastModified() {
        return this.lastModifiedEntries != null;
    }

    public long getLastModifiedEntry(String entryName) {
        Long lastModified;
        if (this.isTrackLastModified() && (lastModified = this.lastModifiedEntries.get(entryName)) != null) {
            return lastModified;
        }
        return 0L;
    }

    public IEntryInfo getEntryInfo(String entryName) {
        IEntryInfo info = this.cacheEntriesInfo.get(entryName);
        if (info == null) {
            info = new XDocArchiveEntryInfo(entryName);
            this.cacheEntriesInfo.put(entryName, info);
        }
        return info;
    }

    public void dispose() {
        if (this.cacheEntries != null) {
            this.cacheEntries.clear();
        }
        this.cacheEntries = null;
        if (this.cacheEntriesInfo != null) {
            this.cacheEntriesInfo.clear();
        }
        this.cacheEntriesInfo = null;
        if (this.lastModifiedEntries != null) {
            this.lastModifiedEntries.clear();
        }
        this.lastModifiedEntries = null;
    }

    private class EntryByteArrayOutputStream
    extends ByteArrayOutputStream {
        private String entryName;

        public EntryByteArrayOutputStream(String entryName) {
            this.entryName = entryName;
        }

        @Override
        public void close() throws IOException {
            XDocArchive.this.cacheEntries.put(this.entryName, this.toByteArray());
            if (XDocArchive.this.isTrackLastModified()) {
                XDocArchive.this.lastModifiedEntries.put(this.entryName, System.currentTimeMillis());
            }
            XDocArchive.this.cacheEntriesWilcard = null;
        }
    }

    private class XDocArchiveEntryInfo
    implements IEntryInfo {
        private final String entryName;

        public XDocArchiveEntryInfo(String entryName) {
            this.entryName = entryName;
        }

        @Override
        public String getName() {
            return this.entryName;
        }

        @Override
        public Reader getReader() {
            return XDocArchive.this.getEntryReader(this.entryName);
        }

        @Override
        public InputStream getInputStream() {
            return XDocArchive.this.getEntryInputStream(this.entryName);
        }

        @Override
        public long getLastModified() {
            return XDocArchive.this.getLastModifiedEntry(this.entryName);
        }
    }
}

