/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.jipviewer;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

class RemoteController
extends Container
implements ActionListener {
    JTextField mHostname;
    SpinnerNumberModel mPortModel = new SpinnerNumberModel(15599, 0, 65355, 1);
    JTextField mState;
    JButton mButton;
    Boolean mIsRunning = null;
    Boolean mNextIsRunning = null;

    RemoteController() {
        JSpinner jSpinner = new JSpinner(this.mPortModel);
        this.mHostname = this.makeTextInput("localhost");
        this.mState = this.makeTextOutput("state");
        this.mButton = this.makeButton("start/stop");
        Container container = this.makePair(this.makeLabel("server hostname"), this.mHostname);
        this.add(container);
        container = this.makePair(this.makeLabel("server port"), jSpinner);
        this.add(container);
        container = this.makePair(this.makeLabel("state"), this.mState);
        this.add(container);
        this.add(this.mButton);
        this.updateState();
        this.setLayout(new BoxLayout(this, 1));
    }

    private void updateState() {
        String string = "unknown";
        String string2 = "stop";
        if (this.mIsRunning == null || this.mIsRunning.booleanValue()) {
            if (this.mIsRunning != null) {
                string = "running";
            }
            string2 = "stop";
            this.mNextIsRunning = false;
        } else {
            string = "stopped";
            string2 = "start";
            this.mNextIsRunning = true;
        }
        this.mState.setText(string);
        this.mButton.setText(string2);
        String string3 = string2;
        this.mButton.setActionCommand(string3);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (!string.equals("start") && !string.equals("stop")) {
            throw new RuntimeException("unexpected button cmd (" + string + ")");
        }
        this.changeState(string);
    }

    void changeState(String string) {
        int n;
        String string2 = this.mHostname.getText();
        if (RemoteController.send(string, string2, n = this.mPortModel.getNumber().intValue())) {
            this.mIsRunning = this.mNextIsRunning;
            this.updateState();
        }
    }

    static boolean send(String string, String string2, int n) {
        try {
            Socket socket = new Socket(string2, n);
            OutputStream outputStream = socket.getOutputStream();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            bufferedOutputStream.write(string.getBytes());
            bufferedOutputStream.write(13);
            bufferedOutputStream.flush();
            socket.close();
            return true;
        }
        catch (IOException iOException) {
            String string3 = "Trouble sending '" + string + "' to " + string2 + ":" + n + ":\n" + iOException;
            String string4 = "error";
            JOptionPane.showMessageDialog(null, string3, string4, 0);
            return false;
        }
    }

    private Container makePair(Component component, Component component2) {
        Container container = new Container();
        container.add(component);
        container.add(this.makeLabel("   "));
        container.add(component2);
        container.setLayout(new BoxLayout(container, 0));
        return container;
    }

    private JButton makeButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    private JLabel makeLabel(String string) {
        JLabel jLabel = new JLabel(string);
        return jLabel;
    }

    private JTextField makeTextInput(String string) {
        JTextField jTextField = new JTextField(string);
        return jTextField;
    }

    private JTextField makeTextOutput(String string) {
        JTextField jTextField = new JTextField(string);
        jTextField.setEditable(false);
        return jTextField;
    }
}

