/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.jipviewer;

import com.tivo.jipviewer.IJipParseHandler;
import com.tivo.jipviewer.JipFrame;
import com.tivo.jipviewer.JipMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JipRun
implements IJipParseHandler {
    private String mDate;
    private long mCurThreadId;
    private Map<Long, List<JipFrame>> mThreads = new HashMap<Long, List<JipFrame>>();
    private long mCurInteractionId;
    private JipFrame mCurFrame;
    private Map<String, String> mFullClassNames = new TreeMap<String, String>();
    private Map<JipMethod, PerMethodInfo> mPerMethods = new HashMap<JipMethod, PerMethodInfo>();

    JipRun() {
    }

    @Override
    public void setDate(String string) {
        if (this.mDate != null) {
            throw new RuntimeException("already set date! (" + this.mDate + ")");
        }
        this.mDate = string;
    }

    @Override
    public void startThread(long l) {
        if (this.mCurThreadId != 0L) {
            throw new RuntimeException("already in thread " + this.mCurThreadId);
        }
        this.mCurThreadId = l;
    }

    @Override
    public void endThread() {
        if (this.mCurThreadId == 0L) {
            throw new RuntimeException("there's no thread to end!");
        }
        this.mCurThreadId = 0L;
    }

    @Override
    public void startInteraction(long l) {
        if (this.mCurInteractionId != 0L) {
            throw new RuntimeException("already in interaction " + this.mCurInteractionId);
        }
        this.mCurInteractionId = l;
    }

    @Override
    public void endInteraction() {
        if (this.mCurInteractionId == 0L) {
            throw new RuntimeException("there's no interaction to end!");
        }
        this.mCurInteractionId = 0L;
    }

    @Override
    public void startFrame(String string, String string2, long l, long l2) {
        JipMethod jipMethod = new JipMethod(string2);
        JipFrame jipFrame = new JipFrame(this.mCurFrame, jipMethod, this.mCurThreadId, l, l2);
        if (this.mCurFrame == null) {
            List<JipFrame> list = this.mThreads.get(this.mCurThreadId);
            if (list == null) {
                list = new ArrayList<JipFrame>();
                this.mThreads.put(this.mCurThreadId, list);
            }
            list.add(jipFrame);
        }
        this.mCurFrame = jipFrame;
    }

    @Override
    public void endFrame() {
        this.mCurFrame.computeNetTime();
        this.updatePerMethodInfo(this.mCurFrame);
        this.mCurFrame = this.mCurFrame.getParentOrNull();
    }

    @Override
    public void addToClassMap(String string, String string2) {
        this.mFullClassNames.put(string, string2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JipRun\n");
        stringBuffer.append("{\n");
        for (Long l : this.mThreads.keySet()) {
            int n = 1;
            for (JipFrame jipFrame : this.mThreads.get(l)) {
                stringBuffer.append("* thread " + l + " interaction " + n + "\n");
                stringBuffer.append(jipFrame);
                ++n;
            }
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public Iterable<Long> threads() {
        return this.mThreads.keySet();
    }

    long getTotalTimeForAllThreads() {
        long l = 0L;
        for (Long l2 : this.threads()) {
            for (JipFrame jipFrame : this.mThreads.get((long)l2)) {
                l += jipFrame.getTotalTime();
            }
        }
        return l;
    }

    public Iterable<JipFrame> interactions(long l) {
        return this.mThreads.get(l);
    }

    public Iterable<JipFrame> allCallers(JipMethod jipMethod) {
        HashSet<JipFrame> hashSet = new HashSet<JipFrame>();
        PerMethodInfo perMethodInfo = this.mPerMethods.get(jipMethod);
        if (perMethodInfo != null) {
            for (JipFrame jipFrame : perMethodInfo.allFrames()) {
                JipFrame jipFrame2 = jipFrame.getParentOrNull();
                if (jipFrame2 == null) continue;
                hashSet.add(jipFrame2);
            }
        }
        return hashSet;
    }

    public Iterable<JipFrame> allCallees(JipMethod jipMethod) {
        HashSet<JipFrame> hashSet = new HashSet<JipFrame>();
        PerMethodInfo perMethodInfo = this.mPerMethods.get(jipMethod);
        if (perMethodInfo != null) {
            for (JipFrame jipFrame : perMethodInfo.allFrames()) {
                for (JipFrame jipFrame2 : jipFrame.getChildren()) {
                    hashSet.add(jipFrame2);
                }
            }
        }
        return hashSet;
    }

    public List<PerMethodInfo> perMethodsInTotalTimeOrder() {
        Comparator<PerMethodInfo> comparator = new Comparator<PerMethodInfo>(){

            @Override
            public int compare(PerMethodInfo perMethodInfo, PerMethodInfo perMethodInfo2) {
                long l;
                long l2 = perMethodInfo.getAllThreadAllFramesTime();
                if (l2 < (l = perMethodInfo2.getAllThreadAllFramesTime())) {
                    return -1;
                }
                if (l2 > l) {
                    return 1;
                }
                String string = perMethodInfo.getMethod().getMethodName();
                String string2 = perMethodInfo.getMethod().getMethodName();
                return string.compareToIgnoreCase(string2);
            }
        };
        ArrayList<PerMethodInfo> arrayList = new ArrayList<PerMethodInfo>(this.mPerMethods.values());
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    public PerMethodInfo getPerMethod(JipMethod jipMethod) {
        PerMethodInfo perMethodInfo = this.mPerMethods.get(jipMethod);
        if (perMethodInfo == null) {
            throw new RuntimeException("unknown method (" + jipMethod + ")?");
        }
        return perMethodInfo;
    }

    private void updatePerMethodInfo(JipFrame jipFrame) {
        JipMethod jipMethod = jipFrame.getMethod();
        PerMethodInfo perMethodInfo = this.mPerMethods.get(jipMethod);
        if (perMethodInfo == null) {
            perMethodInfo = new PerMethodInfo(jipMethod);
            this.mPerMethods.put(jipMethod, perMethodInfo);
        }
        perMethodInfo.addFrame(jipFrame);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PerMethodInfo {
        private JipMethod mMethod;
        private long mAllThreadsAllFramesTime;
        private long mAllThreadsAllFramesTimeIncludingReentrant;
        private List<JipFrame> mvFrame = new ArrayList<JipFrame>();

        PerMethodInfo(JipMethod jipMethod) {
            this.mMethod = jipMethod;
        }

        JipMethod getMethod() {
            return this.mMethod;
        }

        void addFrame(JipFrame jipFrame) {
            this.mvFrame.add(jipFrame);
            long l = jipFrame.getTotalTime();
            this.mAllThreadsAllFramesTimeIncludingReentrant += l;
            if (!jipFrame.isReentrant()) {
                this.mAllThreadsAllFramesTime += l;
            }
        }

        long getAllThreadAllFramesTime() {
            return this.mAllThreadsAllFramesTime;
        }

        long getAllThreadAllFramesTimeIncludingReentrant() {
            return this.mAllThreadsAllFramesTimeIncludingReentrant;
        }

        Iterable<JipFrame> allFrames() {
            return this.mvFrame;
        }

        public String toString() {
            return this.mMethod.getMethodName();
        }
    }
}

