/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.samples;

import com.flowkraft.common.AppPaths;
import com.flowkraft.jobman.dtos.FindCriteriaDto;
import com.flowkraft.jobman.services.SystemService;
import com.sourcekraft.documentburster.common.settings.model.ConfigurationFileInfo;
import com.sourcekraft.documentburster.common.settings.model.DocumentBursterSettings;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SamplesFrendOnlyService {
    private static final Logger log = LoggerFactory.getLogger(SamplesFrendOnlyService.class);
    public static final String FREND_SAMPLES_SUBFOLDER = "_frend";
    @Autowired
    SystemService systemService;
    private List<ConfigurationFileInfo> cachedFrendSamples = null;
    private final Object cacheLock = new Object();

    public String getFrendSamplesBasePath() {
        return AppPaths.CONFIG_DIR_PATH + "/samples/_frend";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigurationFileInfo> getFrendSamples() throws Exception {
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.cachedFrendSamples == null) {
                this.cachedFrendSamples = this.loadFrendSamplesFromDisk();
            }
            return this.cachedFrendSamples;
        }
    }

    public ConfigurationFileInfo getOrProvisionFrendSample(String reportCode) throws Exception {
        String frendSamplesBase = this.getFrendSamplesBasePath();
        Path sampleDir = Paths.get(frendSamplesBase, reportCode);
        if (!Files.exists(sampleDir, new LinkOption[0]) || !Files.isDirectory(sampleDir, new LinkOption[0])) {
            log.warn("Frend sample folder not found: {}", (Object)sampleDir);
            return null;
        }
        Path settingsPath = sampleDir.resolve("settings.xml");
        Path reportingPath = sampleDir.resolve("reporting.xml");
        boolean wasProvisioned = false;
        if (!Files.exists(settingsPath, new LinkOption[0])) {
            log.info("Auto-creating settings.xml for frend sample: {}", (Object)reportCode);
            this.provisionSettingsXml(sampleDir, reportCode);
            wasProvisioned = true;
        }
        if (!Files.exists(reportingPath, new LinkOption[0])) {
            log.info("Auto-creating reporting.xml for frend sample: {}", (Object)reportCode);
            this.provisionReportingXml(sampleDir, reportCode);
            wasProvisioned = true;
        }
        if (wasProvisioned) {
            this.refreshFrendSamples();
        }
        return this.loadFrendSampleConfig(settingsPath.toString());
    }

    public Optional<ConfigurationFileInfo> getFrendSampleByPath(String filePath) throws Exception {
        return this.getFrendSamples().stream().filter(s -> s.filePath.equals(filePath)).findFirst();
    }

    public Optional<ConfigurationFileInfo> getFrendSampleByReportCode(String reportCode) throws Exception {
        return this.getFrendSamples().stream().filter(s -> s.folderName.equals(reportCode)).findFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshFrendSamples() {
        Object object = this.cacheLock;
        synchronized (object) {
            this.cachedFrendSamples = null;
        }
    }

    private List<ConfigurationFileInfo> loadFrendSamplesFromDisk() throws Exception {
        ArrayList<ConfigurationFileInfo> samples = new ArrayList<ConfigurationFileInfo>();
        String frendSamplesDir = this.getFrendSamplesBasePath();
        if (StringUtils.isBlank((CharSequence)frendSamplesDir) || !Files.exists(Paths.get(frendSamplesDir, new String[0]), new LinkOption[0])) {
            log.debug("Frend samples directory does not exist: {}", (Object)frendSamplesDir);
            return samples;
        }
        ArrayList<String> matching = new ArrayList<String>();
        matching.add("settings.xml");
        FindCriteriaDto criteriaDto = new FindCriteriaDto(matching, Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true));
        List sampleFilePaths = this.systemService.unixCliFind(frendSamplesDir, criteriaDto);
        for (String filePath : sampleFilePaths) {
            try {
                ConfigurationFileInfo info = this.loadFrendSampleConfig(filePath);
                if (info == null) continue;
                samples.add(info);
            }
            catch (Exception e) {
                log.error("Failed to load frend sample config: {} - {}", (Object)filePath, (Object)e.getMessage());
            }
        }
        return samples;
    }

    private ConfigurationFileInfo loadFrendSampleConfig(String filePath) throws Exception {
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        ConfigurationFileInfo info = new ConfigurationFileInfo();
        info.filePath = filePath;
        info.fileName = file.getName();
        Path path = Paths.get(filePath, new String[0]);
        if (path.getParent() != null) {
            info.folderName = path.getParent().getFileName().toString();
        }
        try (FileInputStream fis = new FileInputStream(file);){
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DocumentBursterSettings.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            DocumentBursterSettings settings = (DocumentBursterSettings)unmarshaller.unmarshal((InputStream)fis);
            info.templateName = settings.settings != null && settings.settings.template != null && !settings.settings.template.isBlank() ? settings.settings.template : this.toCamelCaseDisplayName(info.folderName);
        }
        return info;
    }

    private void provisionSettingsXml(Path sampleDir, String reportCode) throws Exception {
        String defaultSettingsPath = AppPaths.CONFIG_DIR_PATH + "/_defaults/settings.xml";
        Path targetPath = sampleDir.resolve("settings.xml");
        FileUtils.copyFile((File)new File(defaultSettingsPath), (File)targetPath.toFile());
        String content = FileUtils.readFileToString((File)targetPath.toFile(), (String)"UTF-8");
        String displayName = this.toCamelCaseDisplayName(reportCode);
        content = content.replace("<template>My Reports</template>", "<template>" + displayName + "</template>");
        content = content.replace("<reportdistribution>true</reportdistribution>", "<reportdistribution>false</reportdistribution>");
        content = content.replace("<reportgenerationmailmerge>false</reportgenerationmailmerge>", "<reportgenerationmailmerge>true</reportgenerationmailmerge>");
        FileUtils.writeStringToFile((File)targetPath.toFile(), (String)content, (String)"UTF-8");
        log.info("Created settings.xml for frend sample: {}", (Object)reportCode);
    }

    private void provisionReportingXml(Path sampleDir, String reportCode) throws Exception {
        String defaultReportingPath = AppPaths.CONFIG_DIR_PATH + "/_defaults/reporting.xml";
        Path targetPath = sampleDir.resolve("reporting.xml");
        FileUtils.copyFile((File)new File(defaultReportingPath), (File)targetPath.toFile());
        String content = FileUtils.readFileToString((File)targetPath.toFile(), (String)"UTF-8");
        content = content.replace("ds.csvfile", "ds.scriptfile");
        content = content.replaceAll("(?s)<conncode\\s*/>|<conncode>\\s*</conncode>", "<conncode>rbt-sample-northwind-sqlite-4f2</conncode>");
        String dsScriptName = reportCode + "-script.groovy";
        content = content.replaceAll("(?s)<scriptname\\s*/>|<scriptname>\\s*</scriptname>", "<scriptname>" + dsScriptName + "</scriptname>");
        FileUtils.writeStringToFile((File)targetPath.toFile(), (String)content, (String)"UTF-8");
        Path scriptPath = sampleDir.resolve(dsScriptName);
        if (!Files.exists(scriptPath, new LinkOption[0])) {
            Files.createFile(scriptPath, new FileAttribute[0]);
            log.info("Created empty script file: {}", (Object)scriptPath);
        }
        log.info("Created reporting.xml for frend sample: {}", (Object)reportCode);
    }

    private String toCamelCaseDisplayName(String folderName) {
        if (StringUtils.isBlank((CharSequence)folderName)) {
            return folderName;
        }
        String[] parts = folderName.split("[-_]");
        return Arrays.stream(parts).filter(StringUtils::isNotBlank).map(part -> StringUtils.capitalize((String)part.toLowerCase())).collect(Collectors.joining(""));
    }

    public Map<String, Object> getFrendSampleData(String reportCode) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String frendSamplesBase = this.getFrendSamplesBasePath();
        Path sampleDir = Paths.get(frendSamplesBase, reportCode);
        if (!Files.exists(sampleDir, new LinkOption[0])) {
            throw new IllegalArgumentException("Frend sample not found: " + reportCode);
        }
        if (Files.exists(sampleDir, new LinkOption[0])) {
            try (Stream<Path> files = Files.list(sampleDir);){
                files.filter(p -> {
                    String name = p.getFileName().toString().toLowerCase();
                    return name.endsWith(".csv") || name.endsWith(".json");
                }).findFirst().ifPresent(dataFile -> {
                    result.put("dataFile", dataFile.toString());
                    result.put("dataFileName", dataFile.getFileName().toString());
                });
            }
        }
        result.put("reportCode", reportCode);
        result.put("sampleDir", sampleDir.toString());
        return result;
    }

    public boolean isFrendOnlySample(String configFilePath) {
        if (StringUtils.isBlank((CharSequence)configFilePath)) {
            return false;
        }
        String normalized = configFilePath.replace("\\", "/");
        return normalized.contains("/samples/_frend/");
    }
}

