/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.licenseman;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flowkraft.cfgman.DocumentBursterSettingsService;
import com.flowkraft.common.AppPaths;
import com.flowkraft.common.Utils;
import com.flowkraft.jobman.services.ShellService;
import com.flowkraft.licenseman.AboutInfo;
import com.flowkraft.licenseman.model.LicenseDetails;
import de.ailis.pherialize.Pherialize;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LicenseService {
    @Autowired
    DocumentBursterSettingsService settingsService;
    @Autowired
    private ShellService shellService;
    private String licenseFilePath = AppPaths.WORKSPACE_DIR_PATH + "config/burst/internal/license.xml";

    public void activateLicense() throws Exception {
        this.shellService.runDocumentBursterBatScriptFile("system license activate");
    }

    public void deActivateLicense() throws Exception {
        this.shellService.runDocumentBursterBatScriptFile("system license deactivate");
    }

    public void checkLicense() throws Exception {
        this.shellService.runDocumentBursterBatScriptFile("system license check");
    }

    public LicenseDetails loadLicenseFile() throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{LicenseDetails.class});
        Unmarshaller u = jc.createUnmarshaller();
        return (LicenseDetails)u.unmarshal(new File(this.licenseFilePath));
    }

    public void saveLicenseFile(LicenseDetails licenseInfo) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{LicenseDetails.class});
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.marshal((Object)licenseInfo, new File(this.licenseFilePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AboutInfo getLatestVersionAndChangeLogInformation() throws Exception {
        AboutInfo productInfo = new AboutInfo();
        productInfo.product = Utils.getProductName();
        String url = "https://www.pdfburst.com/store/?edd_action=get_version&item_name=" + Utils.getProductName();
        Client client = this._newClient();
        try {
            Response response = client.target(url).request(new MediaType[]{MediaType.TEXT_PLAIN_TYPE}).get();
            JsonNode jsonNodeResult = new ObjectMapper().readTree((String)response.readEntity(String.class));
            productInfo.latestversion = jsonNodeResult.get("new_version").asText();
            productInfo.changelog = Pherialize.unserialize((String)jsonNodeResult.get("sections").asText()).toArray().getString((Object)"changelog");
        }
        catch (Exception e) {
            productInfo.changelog = "";
            productInfo.latestversion = "";
        }
        finally {
            client.close();
            if (StringUtils.isNotEmpty((CharSequence)productInfo.changelog)) {
                productInfo.changelog = StringUtils.replace((String)productInfo.changelog, (String)"<p>", (String)"\n");
                productInfo.changelog = StringUtils.replace((String)productInfo.changelog, (String)"</p>", (String)"\n");
                productInfo.changelog = StringUtils.replace((String)productInfo.changelog, (String)"<br />", (String)"");
                productInfo.changelog = StringUtils.replace((String)productInfo.changelog, (String)"<br/>", (String)"");
            }
        }
        return productInfo;
    }

    private Client _newClient() throws Exception {
        TrustManager[] trustManager = new X509TrustManager[]{new /* Unavailable Anonymous Inner Class!! */};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustManager, null);
        return ClientBuilder.newBuilder().sslContext(sslContext).hostnameVerifier((s1, s2) -> true).build();
    }
}

