/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.jobman.services;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flowkraft.common.AppPaths;
import com.flowkraft.common.Utils;
import com.flowkraft.jobman.dtos.DirCriteriaDto;
import com.flowkraft.jobman.dtos.FileCriteriaDto;
import com.flowkraft.jobman.dtos.FindCriteriaDto;
import com.flowkraft.jobman.dtos.InspectResultDto;
import com.flowkraft.jobman.dtos.ProcessOutputResultDto;
import com.flowkraft.jobman.models.SystemInfo;
import com.flowkraft.jobman.services.SystemService;
import com.sourcekraft.documentburster.common.ServicesManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListener;
import org.apache.commons.lang3.StringUtils;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.stereotype.Service;
import org.unix4j.Unix4j;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class SystemService {
    @Autowired
    private SimpMessageSendingOperations messagingTemplate;
    private Map<String, Tailer> existingTailers = new HashMap();

    public SystemInfo getSystemInfo() throws Exception {
        SystemInfo info = new SystemInfo();
        info.osName = System.getProperty("os.name");
        info.osVersion = System.getProperty("os.version");
        info.userName = System.getProperty("user.name");
        info.osArch = System.getProperty("os.arch");
        info.product = "ReportBurster";
        ArrayList<String> matching = new ArrayList<String>();
        matching.add("startServer.*");
        Optional<Boolean> files = Optional.of(true);
        Optional<Boolean> directories = Optional.of(false);
        Optional<Boolean> recursive = Optional.of(false);
        Optional<Boolean> ignoreCase = Optional.of(false);
        FindCriteriaDto criteria = new FindCriteriaDto(matching, (Boolean)files.orElse(null), (Boolean)directories.orElse(null), (Boolean)recursive.orElse(null), (Boolean)ignoreCase.orElse(null));
        List startServerScripts = this.unixCliFind(AppPaths.PORTABLE_EXECUTABLE_DIR_PATH, criteria);
        if (!Objects.isNull(startServerScripts) && startServerScripts.size() > 0) {
            info.product = "ReportBurster Server";
        }
        return info;
    }

    public String unixCliCat(String path) {
        File file = new File(path.trim());
        if (!file.exists()) {
            return "";
        }
        Stream stream = Unix4j.builder().cd(AppPaths.PORTABLE_EXECUTABLE_DIR_PATH).cat(new String[]{path}).toStringStream();
        return stream.collect(Collectors.joining("\n"));
    }

    public List<String> unixCliFind(String path, FindCriteriaDto criteria) throws Exception {
        Stream<Path> stream = criteria.isRecursive() ? Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]) : Files.list(Paths.get(path, new String[0]));
        if (criteria.isFiles()) {
            stream = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
        }
        if (criteria.isDirectories()) {
            stream = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
        }
        if (criteria.getMatching() != null) {
            stream = stream.filter(filePath -> {
                String fileName = filePath.getFileName().toString();
                return criteria.getMatching().stream().anyMatch(pattern -> {
                    Object regexPattern = pattern.replace(".", "\\.").replace("*", ".*").replace("?", ".");
                    if (criteria.isIgnoreCase()) {
                        regexPattern = "(?i)" + (String)regexPattern;
                    }
                    return fileName.matches((String)regexPattern);
                });
            });
        }
        List<String> list = stream.map(Path::toAbsolutePath).map(Path::normalize).map(Path::toString).map(p -> p.replace("\\", "/")).map(p -> p.replace(AppPaths.PORTABLE_EXECUTABLE_DIR_PATH, "")).collect(Collectors.toList());
        return list;
    }

    public void startTailer(String fileName) throws Exception {
        if (!Objects.isNull(this.existingTailers.get(fileName))) {
            throw new Exception("A tailer is already started for " + fileName);
        }
        Tailer tailer = new Tailer(new File(AppPaths.LOGS_DIR_PATH + "/" + fileName), (TailerListener)new /* Unavailable Anonymous Inner Class!! */);
        this.existingTailers.put(fileName, tailer);
        tailer.run();
    }

    public void stopTailer(String fileName) {
        Tailer tailer = (Tailer)this.existingTailers.get(fileName);
        if (!Objects.isNull(tailer)) {
            tailer.stop();
            this.existingTailers.remove(fileName);
        }
    }

    public Mono<ProcessOutputResultDto> spawn(List<String> args, Optional<String> cwdPath) throws Exception {
        ArrayList<String> commandWithShell = new ArrayList<String>();
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            commandWithShell.add("cmd.exe");
            commandWithShell.add("/c");
        } else if (os.contains("nix") || os.contains("nux") || os.contains("mac")) {
            commandWithShell.add("/bin/sh");
        }
        ArrayList<String> newArgs = new ArrayList<String>();
        for (String arg : args) {
            String modifiedArg = arg.replace("PORTABLE_EXECUTABLE_DIR_PATH/", AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/");
            if (os.contains("nix") || os.contains("nux") || os.contains("mac")) {
                modifiedArg = modifiedArg.replace(".bat", ".sh");
            }
            newArgs.add(modifiedArg);
        }
        for (String arg : commandWithShell) {
        }
        for (String arg : newArgs) {
        }
        commandWithShell.addAll(newArgs);
        Object workingDirectoryPath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH;
        if (cwdPath.isPresent()) {
            workingDirectoryPath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/" + URLDecoder.decode(cwdPath.get(), StandardCharsets.UTF_8.toString());
        }
        ProcessBuilder processBuilder = new ProcessBuilder(commandWithShell);
        processBuilder.directory(new File((String)workingDirectoryPath));
        Process process = processBuilder.start();
        Flux stdoutFlux = Flux.using(() -> new BufferedReader(new InputStreamReader(process.getInputStream())), reader -> Flux.fromStream(reader.lines()), (Consumer)Utils.uncheckedConsumer(BufferedReader::close));
        Flux stderrFlux = Flux.using(() -> new BufferedReader(new InputStreamReader(process.getErrorStream())), reader -> Flux.fromStream(reader.lines()), (Consumer)Utils.uncheckedConsumer(BufferedReader::close));
        return Flux.merge((Publisher[])new Publisher[]{stdoutFlux, stderrFlux}).collectList().map(outputLines -> new ProcessOutputResultDto(process.exitValue() == 0, outputLines)).doOnTerminate(process::destroy);
    }

    public ProcessOutput execProcess(String command) throws Exception {
        Process process = Runtime.getRuntime().exec(command);
        PipedInputStream stdoutPipedInput = new PipedInputStream();
        PipedOutputStream stdoutPipedOutput = new PipedOutputStream(stdoutPipedInput);
        Thread stdoutThread = new Thread(() -> {
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            PrintWriter writer = new PrintWriter(stdoutPipedOutput);
            reader.lines().forEach(writer::println);
        });
        PipedInputStream stderrPipedInput = new PipedInputStream();
        PipedOutputStream stderrPipedOutput = new PipedOutputStream(stderrPipedInput);
        Thread stderrThread = new Thread(() -> {
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            PrintWriter writer = new PrintWriter(stderrPipedOutput);
            reader.lines().forEach(writer::println);
        });
        stdoutThread.start();
        stderrThread.start();
        ProcessOutput output = new ProcessOutput(this);
        output.stdout = new BufferedReader(new InputStreamReader(stdoutPipedInput)).lines();
        output.stderr = new BufferedReader(new InputStreamReader(stderrPipedInput)).lines();
        return output;
    }

    public String fsResolvePath(String path) {
        Path base = Paths.get(AppPaths.PORTABLE_EXECUTABLE_DIR_PATH, new String[0]).toAbsolutePath();
        Path pathToResolve = Paths.get(path, new String[0]);
        Path relative = base.relativize(base.resolve(pathToResolve));
        Path resolved = base.resolve(relative);
        return resolved.toAbsolutePath().normalize().toString();
    }

    public void fsWriteStringToFile(String path, Optional<String> content) throws Exception {
        Path filePath = Paths.get(path, new String[0]);
        Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        if (content.isPresent()) {
            Files.write(filePath, content.get().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        } else {
            Files.write(filePath, "".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    public boolean fsDelete(String path) throws Exception {
        Path filePath = Paths.get(path, new String[0]);
        if (Files.isDirectory(filePath, new LinkOption[0])) {
            FileUtils.deleteDirectory((File)new File(path));
            return true;
        }
        return Files.deleteIfExists(filePath);
    }

    public void fsCopy(String from, String to, boolean overwrite, String[] matching, boolean ignoreCase) throws Exception {
        CopyOption[] copyOptionArray;
        Path sourcePath = Paths.get(from, new String[0]);
        Path destinationPath = Paths.get(to, new String[0]);
        if (overwrite) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        CopyOption[] options = copyOptionArray;
        FileSystem fs = FileSystems.getDefault();
        PathMatcher[] matchers = !Objects.isNull(matching) ? (PathMatcher[])Stream.of(matching).map(pattern -> fs.getPathMatcher("glob:" + (ignoreCase ? pattern.toLowerCase() : pattern))).toArray(PathMatcher[]::new) : new PathMatcher[]{};
        Files.walk(sourcePath, new FileVisitOption[0]).filter(source -> matchers.length == 0 || Stream.of(matchers).anyMatch(matcher -> matcher.matches((Path)source))).forEach(source -> this.fsCopy(source, destinationPath.resolve(sourcePath.relativize((Path)source)), options));
    }

    public void fsMove(Path from, Path to, boolean overwrite) throws Exception {
        CopyOption[] copyOptionArray;
        MoveOptions options = new MoveOptions();
        options.overwrite = overwrite;
        if (options.overwrite) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        CopyOption[] copyOptions = copyOptionArray;
        Files.move(from, to, copyOptions);
    }

    public String fsExists(String path) throws Exception {
        Path filePath = Paths.get(path, new String[0]);
        if (!Files.exists(filePath, new LinkOption[0])) {
            return "false";
        }
        if (Files.isDirectory(filePath, new LinkOption[0])) {
            return "dir";
        }
        if (Files.isRegularFile(filePath, new LinkOption[0])) {
            return "file";
        }
        return "other";
    }

    public String fsDir(String path, Optional<DirCriteriaDto> criteria) throws Exception {
        Path dirPath = Paths.get(path, new String[0]);
        if (Files.exists(dirPath, new LinkOption[0])) {
            if (!Files.isDirectory(dirPath, new LinkOption[0])) {
                throw new RuntimeException("Path exists but is not a directory");
            }
            if (criteria.isPresent()) {
                DirCriteriaDto c = criteria.get();
                if (c.isEmpty() && dirPath.toFile().list().length > 0) {
                    try (Stream<Path> paths = Files.walk(dirPath, new FileVisitOption[0]);){
                        paths.filter(p -> !p.equals(dirPath)).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                    }
                }
                if (!StringUtils.isBlank((CharSequence)c.getMode())) {
                    Set<PosixFilePermission> perms = PosixFilePermissions.fromString(c.getMode());
                    Files.setPosixFilePermissions(dirPath, perms);
                }
            }
        } else {
            Files.createDirectories(dirPath, new FileAttribute[0]);
        }
        return dirPath.toString().replace("\\", "/");
    }

    public String fsFile(String path, Optional<FileCriteriaDto> criteria) throws Exception {
        Path filePath = Paths.get(path, new String[0]);
        if (!Files.exists(filePath, new LinkOption[0])) {
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            Files.createFile(filePath, new FileAttribute[0]);
        }
        if (criteria.isPresent()) {
            FileCriteriaDto c = criteria.get();
            if (!Objects.isNull(c.getContent())) {
                if (c.getContent() instanceof String) {
                    Files.write(filePath, ((String)c.getContent()).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                } else if (c.getContent() instanceof byte[]) {
                    Files.write(filePath, (byte[])c.getContent(), new OpenOption[0]);
                } else if (c.getContent() instanceof ByteBuffer) {
                    Files.write(filePath, ((ByteBuffer)c.getContent()).array(), new OpenOption[0]);
                } else {
                    ObjectMapper objectMapper = new ObjectMapper();
                    objectMapper.writerWithDefaultPrettyPrinter().writeValue(filePath.toFile(), c.getContent());
                }
            }
            if (!Objects.isNull(c.getMode())) {
                Set<PosixFilePermission> perms = PosixFilePermissions.fromString(c.getMode());
                Files.setPosixFilePermissions(filePath, perms);
            }
        }
        return path;
    }

    public Optional<InspectResultDto> fsInspect(String path, Optional<String> checksum, Optional<Boolean> mode, Optional<Boolean> times, Optional<Boolean> absolutePath, Optional<String> symlinks) throws Exception {
        Path filePath = absolutePath.isPresent() && absolutePath.get() != false ? Paths.get(path, new String[0]).toAbsolutePath() : Paths.get(path, new String[0]);
        if (!Files.exists(filePath, new LinkOption[0])) {
            return Optional.empty();
        }
        InspectResultDto result = new InspectResultDto();
        result.setName(filePath.getFileName().toString());
        result.setType(Files.isDirectory(filePath, new LinkOption[0]) ? "dir" : "file");
        if (Files.isRegularFile(filePath, new LinkOption[0])) {
            result.setSize(Long.valueOf(Files.size(filePath)));
        }
        if (mode.isPresent() && mode.get().booleanValue()) {
            result.setMode(Integer.valueOf((Integer)Files.getAttribute(filePath, "unix:mode", new LinkOption[0])));
        }
        if (times.isPresent() && times.get().booleanValue()) {
            BasicFileAttributes attrs = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
            result.setAccessTime(Instant.ofEpochMilli(attrs.lastAccessTime().toMillis()));
            result.setModifyTime(Instant.ofEpochMilli(attrs.lastModifiedTime().toMillis()));
            result.setChangeTime(Instant.ofEpochMilli(attrs.creationTime().toMillis()));
        }
        return Optional.of(result);
    }

    public Mono<ProcessOutputResultDto> installChocolatey() throws Exception {
        String INSTALL_CHOCOLATEY_SCRIPT_CONTENT = "@echo off\n\nSET DIR=%~dp0%\n    \n::download install.ps1\n%systemroot%/System32/WindowsPowerShell/v1.0/powershell.exe -NoProfile -ExecutionPolicy Bypass -Command \"((new-object net.webclient).DownloadFile('https://chocolatey.org/install.ps1','%DIR%install.ps1'))\"\n::run installer\n%systemroot%/System32/WindowsPowerShell/v1.0/powershell.exe -NoProfile -ExecutionPolicy Bypass -Command \"& '%DIR%install.ps1' %*\"\ndel /f /s install.ps1\n";
        Path scriptFilePath = Paths.get("/temp/installChocolatey.cmd", new String[0]);
        Files.write(scriptFilePath, INSTALL_CHOCOLATEY_SCRIPT_CONTENT.getBytes(), new OpenOption[0]);
        String elevatedScriptFilePath = this.getCommandReadyToBeRunAsAdministratorUsingBatchCmd("CALL " + scriptFilePath.toString());
        List<String> commands = Arrays.asList("cmd.exe", "/c", elevatedScriptFilePath);
        return this.spawn(commands, Optional.empty());
    }

    public Mono<ProcessOutputResultDto> unInstallChocolatey() throws Exception {
        String elevatedScriptFilePath = this.getCommandReadyToBeRunAsAdministratorUsingBatchCmd("& ../tools/chocolatey/uninstall.ps1");
        List<String> commands = Arrays.asList("cmd.exe", "/c", elevatedScriptFilePath);
        return this.spawn(commands, Optional.empty());
    }

    public List<ServiceStatusInfo> getAllServicesStatus() throws Exception {
        ArrayList<String> command = new ArrayList<String>();
        command.add("docker");
        command.add("ps");
        command.add("--format");
        command.add("json");
        ProcessResult result = new ProcessExecutor().command(command).readOutput(true).redirectErrorStream(true).execute();
        String output = result.getOutput().getString();
        if (result.getExitValue() != 0) {
            System.err.println("Docker command failed with exit code: " + result.getExitValue());
            System.err.println("Combined output (stdout + stderr): " + output);
            return new ArrayList<ServiceStatusInfo>();
        }
        if ((output = output.trim()).isEmpty()) {
            return new ArrayList<ServiceStatusInfo>();
        }
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<ServiceStatusInfo> statuses = new ArrayList<ServiceStatusInfo>();
        if (output.startsWith("[")) {
            List services = (List)mapper.readValue(output, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            for (Map service : services) {
                ServiceStatusInfo info = new ServiceStatusInfo();
                info.name = (String)service.get("Names");
                String state = (String)service.get("State");
                String statusText = (String)service.get("Status");
                info.health = this.extractHealthStatus(statusText);
                info.status = "running".equals(state) && info.health != null && !"healthy".equals(info.health) ? "starting" : state;
                info.ports = service.get("Ports") != null ? service.get("Ports").toString() : "N/A";
                statuses.add(info);
            }
        } else if (output.startsWith("{")) {
            String[] lines;
            for (String line : lines = output.split("\\R")) {
                if ((line = line.trim()).isEmpty() || !line.startsWith("{")) continue;
                try {
                    Map service = (Map)mapper.readValue(line, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    if (!service.containsKey("Names")) continue;
                    ServiceStatusInfo info = new ServiceStatusInfo();
                    info.name = (String)service.get("Names");
                    String state = (String)service.get("State");
                    String statusText = (String)service.get("Status");
                    info.health = this.extractHealthStatus(statusText);
                    info.status = "running".equals(state) && info.health != null && !"healthy".equals(info.health) ? "starting" : state;
                    info.ports = service.get("Ports") != null ? service.get("Ports").toString() : "N/A";
                    statuses.add(info);
                }
                catch (Exception e) {
                    System.err.println("Failed to parse JSON line: " + line);
                }
            }
        } else {
            System.err.println("Non-JSON output from Docker: " + output);
        }
        this.processPauseCancelJobs();
        return statuses;
    }

    private String extractHealthStatus(String statusText) {
        if (statusText == null) {
            return null;
        }
        if (statusText.contains("(healthy)")) {
            return "healthy";
        }
        if (statusText.contains("(health: starting)")) {
            return "starting";
        }
        if (statusText.contains("(unhealthy)")) {
            return "unhealthy";
        }
        return null;
    }

    private void processPauseCancelJobs() throws Exception {
        Path jobsDir = Paths.get(AppPaths.JOBS_DIR_PATH, new String[0]);
        if (!Files.exists(jobsDir, new LinkOption[0]) || !Files.isDirectory(jobsDir, new LinkOption[0])) {
            return;
        }
        List files = Files.list(jobsDir).collect(Collectors.toList());
        for (Path p : files) {
            String jobtype;
            String[] tokens;
            String baseName;
            String jobFileName;
            Path jobPath;
            String fname = p.getFileName().toString();
            if (!fname.endsWith(".pause") && !fname.endsWith(".cancel") || !Files.exists(jobPath = jobsDir.resolve(jobFileName = (baseName = FilenameUtils.getBaseName((String)fname)) + ".job"), new LinkOption[0])) continue;
            String jobContent = Files.readString(jobPath, StandardCharsets.UTF_8);
            Pattern jobtypePtn = Pattern.compile("<jobtype>(.*?)</jobtype>", 32);
            Matcher jobtypeMatcher = jobtypePtn.matcher(jobContent);
            if (!jobtypeMatcher.find() || (tokens = (jobtype = jobtypeMatcher.group(1).trim()).split("\\s+")).length < 3 || !tokens[0].equalsIgnoreCase("app") || !tokens[1].equalsIgnoreCase("start")) continue;
            String serviceName = tokens[2].trim();
            try {
                ServicesManager.Result r = ServicesManager.execute((String)("app stop " + serviceName));
                String status = r != null ? r.status : "null";
                String output = r != null && r.output != null ? r.output.replaceAll("\r?\n", " ") : "";
                System.out.println("pause/cancel: executed 'app stop " + serviceName + "' -> status=" + status + " output=" + output);
                if ("stopped".equalsIgnoreCase(status) || "ok".equalsIgnoreCase(status)) {
                    FileUtils.deleteQuietly((File)jobPath.toFile());
                    FileUtils.deleteQuietly((File)p.toFile());
                    FileUtils.deleteQuietly((File)jobsDir.resolve(baseName + ".progress").toFile());
                    System.out.println("pause/cancel: cleaned up job files for " + baseName);
                    continue;
                }
                System.err.println("pause/cancel: stop command did not indicate success for " + serviceName + " (status=" + status + "). Leaving signal file for retry.");
            }
            catch (Exception ex) {
                System.err.println("pause/cancel: Exception while executing stop for " + serviceName + ": " + ex.getMessage());
            }
        }
    }

    private String getCommandReadyToBeRunAsAdministratorUsingBatchCmd(String commandToElevate) throws Exception {
        File tempFile = File.createTempFile("elevated-batch-cmd-script", ".cmd", new File("/temp/"));
        String elevatedScriptFilePath = tempFile.getAbsolutePath();
        String scriptContent = "::::::::::::::::::::::::::::::::::::::::::::\n:: Elevate.cmd - Version 4\n:: Automatically check & get admin rights\n:: see \"https://stackoverflow.com/a/12264592/1016343\" for description\n::::::::::::::::::::::::::::::::::::::::::::\n @echo off\n CLS\n ECHO.\n ECHO =============================\n ECHO Please wait... Running '" + commandToElevate + "' as Admin...\n ECHO =============================\n:init\n setlocal DisableDelayedExpansion\n set cmdInvoke=0\n set winSysFolder=System32\n set \"batchPath=%~0\"\n for %%k in (%0) do set batchName=%%~nk\n set \"vbsGetPrivileges=%temp%/OEgetPriv_%batchName%.vbs\"\n setlocal EnableDelayedExpansion\n:checkPrivileges\n  NET FILE 1>NUL 2>NUL\n  if '%errorlevel%' == '0' ( goto gotPrivileges ) else ( goto getPrivileges )\n:getPrivileges\n  if '%1'=='ELEV' (echo ELEV & shift /1 & goto gotPrivileges)\n  ECHO.\n  ECHO **************************************\n  ECHO Invoking UAC for Privilege Escalation\n  ECHO **************************************\n  ECHO Set UAC = CreateObject^(\"Shell.Application\"^) > \"%vbsGetPrivileges%\"\n  ECHO args = \"ELEV \" >> \"%vbsGetPrivileges%\"\n  ECHO For Each strArg in WScript.Arguments >> \"%vbsGetPrivileges%\"\n  ECHO args = args ^& strArg ^& \" \"  >> \"%vbsGetPrivileges%\"\n  ECHO Next >> \"%vbsGetPrivileges%\"\n  if '%cmdInvoke%'=='1' goto InvokeCmd\n  ECHO UAC.ShellExecute \"!batchPath!\", args, \"\", \"runas\", 1 >> \"%vbsGetPrivileges%\"\n  goto ExecElevation\n:InvokeCmd\n  ECHO args = \"/c \"\"\" + \"!batchPath!\" + \"\"\" \" + args >> \"%vbsGetPrivileges%\"\n  ECHO UAC.ShellExecute \"%SystemRoot%/%winSysFolder%/cmd.exe\", args, \"\", \"runas\", 1 >> \"%vbsGetPrivileges%\"\n:ExecElevation\n \"%SystemRoot%/%winSysFolder%/WScript.exe\" \"%vbsGetPrivileges%\" %*\n exit /B\n:gotPrivileges\n setlocal & cd /d %~dp0\n if '%1'=='ELEV' (del \"%vbsGetPrivileges%\" 1>nul 2>nul  &  shift /1)\n::::::::::::::::::::::::\n::START\n::::::::::::::::::::::::\n REM Run shell as admin (example) - put here code as you like\n " + commandToElevate + " 2>&1 >> " + AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/logs/bash.service.log\n del /f /s *.cmd 2>&1 >> " + AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/logs/bash.service.log\n cmd /k\n";
        Files.write(Paths.get(elevatedScriptFilePath, new String[0]), scriptContent.getBytes(), new OpenOption[0]);
        return elevatedScriptFilePath;
    }

    private void fsCopy(Path source, Path dest, CopyOption[] options) {
        try {
            Files.copy(source, dest, options);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

