/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.jobman.services;

import com.flowkraft.cfgman.DocumentBursterSettingsService;
import com.flowkraft.common.AppPaths;
import com.flowkraft.jobman.dtos.ReportFullConfigDto;
import com.flowkraft.samples.SamplesFrendOnlyService;
import com.sourcekraft.documentburster.common.chart.ChartOptions;
import com.sourcekraft.documentburster.common.chart.ChartOptionsParser;
import com.sourcekraft.documentburster.common.db.ReportDataResult;
import com.sourcekraft.documentburster.common.pivottable.PivotTableOptions;
import com.sourcekraft.documentburster.common.pivottable.PivotTableOptionsParser;
import com.sourcekraft.documentburster.common.reportparameters.ReportParametersHelper;
import com.sourcekraft.documentburster.common.settings.Settings;
import com.sourcekraft.documentburster.common.tabulator.TabulatorOptions;
import com.sourcekraft.documentburster.common.tabulator.TabulatorOptionsParser;
import com.sourcekraft.documentburster.job.CliJob;
import com.sourcekraft.documentburster.utils.FreemarkerRenderingUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportingService {
    private static final Logger log = LoggerFactory.getLogger(ReportingService.class);
    @Autowired
    DocumentBursterSettingsService settingsService;
    @Autowired
    SamplesFrendOnlyService samplesFrendOnlyService;

    public ReportDataResult fetchData(String configurationFilePath, Map<String, String> parameters) throws Exception {
        CliJob cliJob = new CliJob(configurationFilePath);
        return cliJob.doFetchData(parameters);
    }

    public ReportFullConfigDto loadReportConfig(String reportCode) throws Exception {
        String configType;
        Path itemDir;
        System.out.println("[DEBUG] ReportingService.loadReportConfig(" + reportCode + ") - START");
        System.out.println("[DEBUG] PORTABLE_EXECUTABLE_DIR_PATH = " + AppPaths.PORTABLE_EXECUTABLE_DIR_PATH);
        ReportFullConfigDto config = new ReportFullConfigDto();
        config.reportCode = reportCode;
        Path reportsDir = Paths.get(AppPaths.PORTABLE_EXECUTABLE_DIR_PATH, "config", "reports", reportCode);
        Path samplesDir = Paths.get(AppPaths.PORTABLE_EXECUTABLE_DIR_PATH, "config", "samples", reportCode);
        System.out.println("[DEBUG] Checking reportsDir: " + String.valueOf(reportsDir) + " exists=" + Files.exists(reportsDir, new LinkOption[0]));
        System.out.println("[DEBUG] Checking samplesDir: " + String.valueOf(samplesDir) + " exists=" + Files.exists(samplesDir, new LinkOption[0]));
        if (Files.exists(reportsDir, new LinkOption[0])) {
            itemDir = reportsDir;
            configType = "config-reports";
        } else if (Files.exists(samplesDir, new LinkOption[0])) {
            itemDir = samplesDir;
            configType = "config-samples";
        } else {
            Path frendSamplesDir = Paths.get(AppPaths.PORTABLE_EXECUTABLE_DIR_PATH, "config", "samples", "_frend", reportCode);
            System.out.println("[DEBUG] Checking frendSamplesDir: " + String.valueOf(frendSamplesDir) + " exists=" + Files.exists(frendSamplesDir, new LinkOption[0]));
            if (Files.exists(frendSamplesDir, new LinkOption[0])) {
                try {
                    System.out.println("[DEBUG] Found _frend sample folder: " + reportCode + " - ensuring settings.xml/reporting.xml exist...");
                    this.samplesFrendOnlyService.getOrProvisionFrendSample(reportCode);
                    itemDir = frendSamplesDir;
                    configType = "config-samples-frend";
                    System.out.println("[DEBUG] Using _frend sample directory: " + String.valueOf(itemDir));
                }
                catch (Exception e) {
                    System.out.println("[DEBUG] Failed loading frend sample: " + e.getMessage());
                    throw new RuntimeException("Report not found: " + reportCode, e);
                }
            } else {
                System.out.println("[DEBUG] Report not found: " + reportCode);
                throw new RuntimeException("Report not found: " + reportCode);
            }
        }
        System.out.println("[DEBUG] Using itemDir: " + String.valueOf(itemDir));
        config.configurationFilePath = "config-reports".equals(configType) ? "./config/reports/" + reportCode + "/settings.xml" : ("config-samples-frend".equals(configType) ? "./config/samples/_frend/" + reportCode + "/settings.xml" : "./config/samples/" + reportCode + "/settings.xml");
        Path settingsPath = itemDir.resolve("settings.xml");
        if (Files.exists(settingsPath, new LinkOption[0])) {
            String content = Files.readString(settingsPath);
            config.reportName = this.extractXmlValue(content, "template");
            config.dsInputType = this.extractReportingDsInputType(itemDir);
        }
        Path paramsPath = itemDir.resolve(reportCode + "-report-parameters-spec.groovy");
        System.out.println("[DEBUG] Parameters DSL path: " + String.valueOf(paramsPath) + " exists=" + Files.exists(paramsPath, new LinkOption[0]));
        if (Files.exists(paramsPath, new LinkOption[0])) {
            String dslContent;
            config.parametersDsl = dslContent = Files.readString(paramsPath);
            System.out.println("[DEBUG] Parameters DSL content (first 200 chars): " + dslContent.substring(0, Math.min(200, dslContent.length())));
            config.parameters = ReportParametersHelper.parseGroovyParametersDslCode((String)dslContent);
            config.hasParameters = config.parameters != null && !config.parameters.isEmpty();
            System.out.println("[DEBUG] Parameters DSL parsed, hasParameters=" + config.hasParameters);
        }
        Path tabulatorPath = itemDir.resolve(reportCode + "-tabulator-config.groovy");
        System.out.println("[DEBUG] Tabulator DSL path: " + String.valueOf(tabulatorPath) + " exists=" + Files.exists(tabulatorPath, new LinkOption[0]));
        if (Files.exists(tabulatorPath, new LinkOption[0])) {
            try {
                String dslContent;
                config.tabulatorDsl = dslContent = Files.readString(tabulatorPath);
                System.out.println("[DEBUG] Tabulator DSL content (first 200 chars): " + dslContent.substring(0, Math.min(200, dslContent.length())));
                TabulatorOptions opts = TabulatorOptionsParser.parseGroovyTabulatorDslCode((String)dslContent);
                System.out.println("[DEBUG] Tabulator DSL parsed successfully, opts=" + (opts != null ? "not null" : "null"));
                if (opts != null) {
                    config.tabulatorOptions = new HashMap();
                    if (opts.getLayoutOptions() != null) {
                        config.tabulatorOptions.put("layoutOptions", opts.getLayoutOptions());
                    }
                    if (opts.getColumns() != null) {
                        config.tabulatorOptions.put("columns", opts.getColumns());
                    }
                    if (opts.getData() != null) {
                        config.tabulatorOptions.put("data", opts.getData());
                    }
                    config.hasTabulator = true;
                }
            }
            catch (Exception e) {
                System.out.println("[DEBUG] ERROR parsing Tabulator DSL: " + e.getMessage());
                e.printStackTrace();
                throw e;
            }
        }
        Path chartPath = itemDir.resolve(reportCode + "-chart-config.groovy");
        System.out.println("[DEBUG] Chart DSL path: " + String.valueOf(chartPath) + " exists=" + Files.exists(chartPath, new LinkOption[0]));
        if (Files.exists(chartPath, new LinkOption[0])) {
            String dslContent;
            config.chartDsl = dslContent = Files.readString(chartPath);
            System.out.println("[DEBUG] Chart DSL content (first 200 chars): " + dslContent.substring(0, Math.min(200, dslContent.length())));
            ChartOptions opts = ChartOptionsParser.parseGroovyChartDslCode((String)dslContent);
            System.out.println("[DEBUG] Chart DSL parsed successfully, opts=" + (opts != null ? "not null" : "null"));
            if (opts != null) {
                config.chartOptions = new HashMap();
                if (opts.getType() != null) {
                    config.chartOptions.put("type", opts.getType());
                }
                if (opts.getLabelField() != null) {
                    config.chartOptions.put("labelField", opts.getLabelField());
                }
                if (opts.getOptions() != null && !opts.getOptions().isEmpty()) {
                    config.chartOptions.put("options", opts.getOptions());
                }
                if (opts.getLabels() != null && !opts.getLabels().isEmpty()) {
                    config.chartOptions.put("labels", opts.getLabels());
                }
                if (opts.getDatasets() != null && !opts.getDatasets().isEmpty()) {
                    config.chartOptions.put("datasets", opts.getDatasets());
                }
                if (opts.getData() != null && !opts.getData().isEmpty()) {
                    config.chartOptions.put("data", opts.getData());
                }
                config.hasChart = true;
            }
        }
        Path pivotPath = itemDir.resolve(reportCode + "-pivot-config.groovy");
        System.out.println("[DEBUG] Pivot DSL path: " + String.valueOf(pivotPath) + " exists=" + Files.exists(pivotPath, new LinkOption[0]));
        if (Files.exists(pivotPath, new LinkOption[0])) {
            String dslContent;
            config.pivotTableDsl = dslContent = Files.readString(pivotPath);
            System.out.println("[DEBUG] Pivot DSL loaded, content length=" + dslContent.length() + ", first 200 chars: " + dslContent.substring(0, Math.min(200, dslContent.length())));
            PivotTableOptions opts = PivotTableOptionsParser.parseGroovyPivotTableDslCode((String)dslContent);
            System.out.println("[DEBUG] Pivot DSL parsed successfully, opts=" + (opts != null ? "not null" : "null"));
            if (opts != null) {
                config.pivotTableOptions = new HashMap();
                if (opts.getRows() != null && !opts.getRows().isEmpty()) {
                    config.pivotTableOptions.put("rows", opts.getRows());
                }
                if (opts.getCols() != null && !opts.getCols().isEmpty()) {
                    config.pivotTableOptions.put("cols", opts.getCols());
                }
                if (opts.getVals() != null && !opts.getVals().isEmpty()) {
                    config.pivotTableOptions.put("vals", opts.getVals());
                }
                if (opts.getAggregatorName() != null) {
                    config.pivotTableOptions.put("aggregatorName", opts.getAggregatorName());
                }
                if (opts.getRendererName() != null) {
                    config.pivotTableOptions.put("rendererName", opts.getRendererName());
                }
                if (opts.getRowOrder() != null) {
                    config.pivotTableOptions.put("rowOrder", opts.getRowOrder());
                }
                if (opts.getColOrder() != null) {
                    config.pivotTableOptions.put("colOrder", opts.getColOrder());
                }
                if (opts.getValueFilter() != null && !opts.getValueFilter().isEmpty()) {
                    config.pivotTableOptions.put("valueFilter", opts.getValueFilter());
                }
                if (opts.getOptions() != null && !opts.getOptions().isEmpty()) {
                    config.pivotTableOptions.put("options", opts.getOptions());
                }
                config.hasPivotTable = true;
                System.out.println("[DEBUG] Pivot config set: hasPivotTable=true, pivotTableDsl length=" + config.pivotTableDsl.length());
            }
        } else {
            System.out.println("[DEBUG] No pivot DSL file found at: " + String.valueOf(pivotPath));
        }
        return config;
    }

    public ReportDataResult fetchReportData(String reportCode, Map<String, String> parameters) throws Exception {
        Path itemDir;
        String cfgFilePath;
        System.out.println("[DEBUG] fetchReportData - START, reportCode=" + reportCode + ", parameters=" + String.valueOf(parameters));
        Path reportsDir = Paths.get(AppPaths.PORTABLE_EXECUTABLE_DIR_PATH, "config", "reports", reportCode);
        Path samplesDir = Paths.get(AppPaths.PORTABLE_EXECUTABLE_DIR_PATH, "config", "samples", reportCode);
        System.out.println("[DEBUG] fetchReportData - reportsDir=" + String.valueOf(reportsDir) + ", exists=" + Files.exists(reportsDir, new LinkOption[0]));
        System.out.println("[DEBUG] fetchReportData - samplesDir=" + String.valueOf(samplesDir) + ", exists=" + Files.exists(samplesDir, new LinkOption[0]));
        if (Files.exists(reportsDir, new LinkOption[0])) {
            cfgFilePath = Paths.get(AppPaths.PORTABLE_EXECUTABLE_DIR_PATH, "config", "reports", reportCode, "settings.xml").toString();
            itemDir = reportsDir;
            System.out.println("[DEBUG] fetchReportData - using reportsDir, cfgFilePath=" + cfgFilePath);
        } else if (Files.exists(samplesDir, new LinkOption[0])) {
            cfgFilePath = Paths.get(AppPaths.PORTABLE_EXECUTABLE_DIR_PATH, "config", "samples", reportCode, "settings.xml").toString();
            itemDir = samplesDir;
            System.out.println("[DEBUG] fetchReportData - using samplesDir, cfgFilePath=" + cfgFilePath);
        } else {
            Path frendSamplesDir = Paths.get(AppPaths.PORTABLE_EXECUTABLE_DIR_PATH, "config", "samples", "_frend", reportCode);
            System.out.println("[DEBUG] Checking frendSamplesDir (data fetch): " + String.valueOf(frendSamplesDir) + " exists=" + Files.exists(frendSamplesDir, new LinkOption[0]));
            if (Files.exists(frendSamplesDir, new LinkOption[0])) {
                try {
                    this.samplesFrendOnlyService.getOrProvisionFrendSample(reportCode);
                    cfgFilePath = Paths.get(AppPaths.PORTABLE_EXECUTABLE_DIR_PATH, "config", "samples", "_frend", reportCode, "settings.xml").toString();
                    itemDir = frendSamplesDir;
                }
                catch (Exception e) {
                    throw new RuntimeException("Report not found: " + reportCode, e);
                }
            } else {
                throw new RuntimeException("Report not found: " + reportCode);
            }
        }
        System.out.println("[DEBUG] fetchReportData - about to call fetchData with cfgFilePath=" + cfgFilePath);
        ReportDataResult result = this.fetchData(cfgFilePath, parameters);
        System.out.println("[DEBUG] fetchReportData - fetchData returned, reportData size=" + String.valueOf(result.reportData != null ? Integer.valueOf(result.reportData.size()) : "null"));
        String entityCode = parameters != null ? parameters.get("entityCode") : null;
        System.out.println("[DEBUG] fetchReportData - entityCode=" + entityCode);
        if (entityCode != null && !entityCode.isEmpty()) {
            result.entityCode = entityCode;
            try {
                Settings settings = new Settings(cfgFilePath);
                settings.loadSettings();
                String outputType = settings.getReportTemplate().outputtype;
                System.out.println("[DEBUG] fetchReportData - outputType=" + outputType);
                if (FreemarkerRenderingUtils.isHtmlBasedOutputType((String)outputType)) {
                    String templatePath = settings.getReportTemplate().retrieveTemplateFilePath();
                    System.out.println("[DEBUG] fetchReportData - templatePath=" + templatePath);
                    Path absoluteTemplatePath = itemDir.resolve(templatePath);
                    System.out.println("[DEBUG] fetchReportData - absoluteTemplatePath=" + String.valueOf(absoluteTemplatePath) + ", exists=" + Files.exists(absoluteTemplatePath, new LinkOption[0]));
                    if (!Files.exists(absoluteTemplatePath, new LinkOption[0])) {
                        absoluteTemplatePath = Paths.get(AppPaths.PORTABLE_EXECUTABLE_DIR_PATH, templatePath);
                        System.out.println("[DEBUG] fetchReportData - trying PORTABLE path: " + String.valueOf(absoluteTemplatePath) + ", exists=" + Files.exists(absoluteTemplatePath, new LinkOption[0]));
                    }
                    if (Files.exists(absoluteTemplatePath, new LinkOption[0])) {
                        if (result.reportData != null && !result.reportData.isEmpty()) {
                            LinkedHashMap entityRow = (LinkedHashMap)result.reportData.get(0);
                            System.out.println("[DEBUG] fetchReportData - entityRow keys=" + String.valueOf(entityRow.keySet()));
                            HashMap userVariables = new HashMap(entityRow);
                            result.renderedHtml = FreemarkerRenderingUtils.renderTemplate((String)absoluteTemplatePath.toString(), userVariables);
                            System.out.println("[DEBUG] fetchReportData - renderedHtml length=" + String.valueOf(result.renderedHtml != null ? Integer.valueOf(result.renderedHtml.length()) : "null"));
                            log.info("Rendered HTML for entity '{}' from template '{}'", (Object)entityCode, (Object)absoluteTemplatePath);
                        } else {
                            System.out.println("[DEBUG] fetchReportData - No data returned for entityCode: " + entityCode);
                            log.warn("No data returned for entityCode: {}", (Object)entityCode);
                        }
                    } else {
                        System.out.println("[DEBUG] fetchReportData - Template file not found: " + String.valueOf(absoluteTemplatePath));
                        log.warn("Template file not found: {}", (Object)absoluteTemplatePath);
                    }
                } else {
                    System.out.println("[DEBUG] fetchReportData - Output type is not HTML-based: " + outputType);
                    log.debug("Output type '{}' is not HTML-based, skipping template rendering", (Object)outputType);
                }
            }
            catch (Exception e) {
                System.out.println("[DEBUG] fetchReportData - EXCEPTION: " + e.getMessage());
                e.printStackTrace();
                log.error("Failed to render HTML for entity '{}': {}", new Object[]{entityCode, e.getMessage(), e});
            }
        }
        System.out.println("[DEBUG] fetchReportData - END, returning result with renderedHtml=" + (String)(result.renderedHtml != null ? result.renderedHtml.length() + " chars" : "null"));
        return result;
    }

    private String extractXmlValue(String content, String tag) {
        int startPos = content.indexOf("<" + tag + ">") + tag.length() + 2;
        int endPos = content.indexOf("</" + tag + ">");
        if (startPos > tag.length() + 1 && endPos > startPos) {
            return content.substring(startPos, endPos).trim();
        }
        return "";
    }

    private String extractReportingDsInputType(Path itemDir) {
        try {
            Path reportingPath = itemDir.resolve("reporting.xml");
            if (Files.exists(reportingPath, new LinkOption[0])) {
                String content = Files.readString(reportingPath);
                return this.extractXmlValue(content, "type");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }
}

