/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.jobman.services;

import com.flowkraft.common.AppPaths;
import com.flowkraft.common.Utils;
import com.flowkraft.jobman.api.JobsApi;
import com.flowkraft.jobman.models.ClientServerCommunicationInfo;
import com.flowkraft.jobman.models.FileInfo;
import com.flowkraft.jobman.services.JobsService;
import com.flowkraft.jobman.services.ShellService;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unix4j.Unix4j;

@Service
public class JobsService
implements JobsApi {
    public State state = new State(this);
    @Autowired
    private ShellService shellService;

    public Stream<FileInfo> fetchStats() throws Exception {
        List allJobFileNames = Unix4j.cd((String)AppPaths.JOBS_DIR_PATH).ls().toStringList();
        ArrayList<FileInfo> allJobDetails = new ArrayList<FileInfo>();
        boolean trimFileContent = false;
        for (String jobFileName : allJobFileNames) {
            String jobFilePath = AppPaths.JOBS_DIR_PATH + "/" + jobFileName;
            File jobFile = new File(jobFilePath);
            if (!jobFile.exists()) continue;
            try {
                FileInfo jobFileInfo = new FileInfo(jobFileName, Unix4j.cd((String)AppPaths.JOBS_DIR_PATH).cat(new String[]{jobFileName}).toStringResult(), trimFileContent);
                jobFileInfo.filePath = jobFilePath;
                allJobDetails.add(jobFileInfo);
            }
            catch (Exception exception) {}
        }
        return allJobDetails.stream();
    }

    public void doResume(ClientServerCommunicationInfo serverTransactionInfo) throws Exception {
        String jobFilePath = serverTransactionInfo.id;
        this.state.numberOfActiveJobs = 1;
        this.shellService.runDocumentBursterBatScriptFile("resume \"" + jobFilePath + "\"", file -> {
            FileUtils.forceDelete((File)file);
            this.state.numberOfActiveJobs = 0;
        }, new File(serverTransactionInfo.info));
    }

    public void doBurst(ClientServerCommunicationInfo serverTransactionInfo) throws Exception {
        List filesToProcess;
        if (serverTransactionInfo.info.toLowerCase().equals("burst") && (filesToProcess = Utils.getFilesToProcess((String)serverTransactionInfo.id, (String)AppPaths.UPLOADS_DIR_PATH)).size() == 1) {
            FileInfo fileToProcess = (FileInfo)filesToProcess.get(0);
            String filePath = fileToProcess.filePath;
            String fileName = FilenameUtils.getName((String)filePath);
            try {
                FileUtils.moveFile((File)new File(filePath), (File)new File(AppPaths.DEFAULT_POLL_DIR_PATH + "/" + fileName));
                FileUtils.deleteDirectory((File)new File(AppPaths.UPLOADS_DIR_PATH + "/" + serverTransactionInfo.id));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

