/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.jobman.services;

import com.flowkraft.jobman.config.FileExplorerConfiguration;
import com.flowkraft.jobman.models.FileContentVO;
import com.flowkraft.jobman.models.FileTreeVO;
import com.flowkraft.jobman.models.FileVO;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FileExplorerService {
    @Autowired
    private FileExplorerConfiguration explorerConfiguration;

    public Map<String, Object> buildMetaInfo() {
        HashMap<String, Object> metaInfo = new HashMap<String, Object>();
        metaInfo.put("title", StringUtils.isNotEmpty((CharSequence)this.explorerConfiguration.getTitle()) ? this.explorerConfiguration.getTitle() : "");
        metaInfo.put("description", StringUtils.isNotEmpty((CharSequence)this.explorerConfiguration.getDescription()) ? this.explorerConfiguration.getDescription() : "");
        metaInfo.put("quickLinks", this.explorerConfiguration.getQuickLinks() != null ? this.explorerConfiguration.getQuickLinks() : Collections.emptyMap());
        return metaInfo;
    }

    public FileTreeVO buildFileTree(String dir) {
        String currentDirectoryPath;
        File currentDirectory;
        if (dir == null) {
            dir = this.explorerConfiguration.getBaseDirPath();
        }
        if (!((currentDirectory = new File(currentDirectoryPath = StringUtils.isNotEmpty((CharSequence)dir) ? dir : this.explorerConfiguration.getBaseDirPath())).exists() && currentDirectory.isDirectory() && currentDirectory.canRead())) {
            currentDirectory = new File(this.explorerConfiguration.getBaseDirPath());
        }
        if (this.explorerConfiguration.getRestrictToBaseDir().booleanValue() && !this.isWithinBase(currentDirectory)) {
            currentDirectory = new File(this.explorerConfiguration.getBaseDirPath());
        }
        TreeSet<FileVO> childDirectories = new TreeSet<FileVO>();
        TreeSet<FileVO> files = new TreeSet<FileVO>();
        for (File file : currentDirectory.listFiles()) {
            if (file.isDirectory()) {
                childDirectories.add(new FileVO(file));
                continue;
            }
            files.add(new FileVO(file));
        }
        FileTreeVO fileTree = new FileTreeVO();
        fileTree.setCurrentDirectory(new FileVO(currentDirectory));
        if (currentDirectory.getParentFile() != null && (!this.explorerConfiguration.getRestrictToBaseDir().booleanValue() || this.isWithinBase(currentDirectory.getParentFile()))) {
            fileTree.setParentDirectory(new FileVO(currentDirectory.getParentFile()));
        }
        fileTree.setChildDirectories(childDirectories);
        fileTree.setFiles(files);
        return fileTree;
    }

    private boolean isWithinBase(File dir) {
        boolean isWithinBase = false;
        File localDir = dir;
        File baseDir = new File(this.explorerConfiguration.getBaseDirPath());
        if (baseDir.equals(dir)) {
            isWithinBase = true;
        }
        while (!isWithinBase && localDir.getParentFile() != null) {
            if (baseDir.equals(localDir.getParentFile())) {
                isWithinBase = true;
            }
            localDir = localDir.getParentFile();
        }
        return isWithinBase;
    }

    public void setFileExplorerConfiguration(FileExplorerConfiguration explorerConfiguration) {
        this.explorerConfiguration = explorerConfiguration;
    }

    public FileContentVO readFile(String filePath) {
        try {
            File file = new File(filePath);
            FileContentVO fileContentVO = new FileContentVO();
            fileContentVO.setFileName(file.getName());
            fileContentVO.setContent(FileUtils.readFileToByteArray((File)file));
            return fileContentVO;
        }
        catch (IOException exp) {
            return null;
        }
    }
}

