/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.jobman.security;

import com.flowkraft.jobman.security.ApiKeyManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.csrf.CsrfTokenRequestAttributeHandler;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
public class SecurityConfig {
    @Autowired
    private ApiKeyManager apiKeyManager;
    @Value(value="${reportburster.security.enabled:true}")
    private boolean securityEnabled;

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        if (!this.securityEnabled) {
            http.csrf(csrf -> csrf.disable()).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.anyRequest()).permitAll());
            return (SecurityFilterChain)http.build();
        }
        CsrfTokenRequestAttributeHandler requestHandler = new CsrfTokenRequestAttributeHandler();
        requestHandler.setCsrfRequestAttributeName(null);
        ((HttpSecurity)http.cors().and()).csrf(csrf -> csrf.disable()).sessionManagement(session -> session.sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED)).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new String[]{"/rb-webcomponents/**"})).permitAll().requestMatchers(new String[]{"/", "/index.html", "/favicon.ico", "/assets/**", "/lib/frend/**"})).permitAll().requestMatchers(new RequestMatcher[]{request -> {
            String uri = request.getRequestURI();
            return uri != null && (uri.endsWith(".css") || uri.endsWith(".js") || uri.endsWith(".map") || uri.endsWith(".png") || uri.endsWith(".svg") || uri.endsWith(".woff") || uri.endsWith(".woff2") || uri.endsWith(".eot") || uri.endsWith(".ttf") || uri.endsWith(".ico") || uri.startsWith("/.well-known/"));
        }})).permitAll().anyRequest()).permitAll());
        return (SecurityFilterChain)http.build();
    }
}

