/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.jobman.schedulers;

import com.flowkraft.common.Utils;
import com.flowkraft.jobman.services.JobsService;
import com.flowkraft.jobman.services.ShellService;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class PollScheduler {
    @Value(value="${POLLING_PATH:}")
    private String pollingPath;
    @Autowired
    JobsService jobsService;
    @Autowired
    private ShellService shellService;
    private List<String> waitQueue = new LinkedList();

    @PostConstruct
    public void init() {
        if (!StringUtils.isBlank((CharSequence)this.pollingPath)) {
            File pollDirReceived;
            File pollDir = new File(this.pollingPath);
            if (!pollDir.exists()) {
                pollDir.mkdirs();
            }
            if (!(pollDirReceived = new File(this.pollingPath + "/received")).exists()) {
                pollDirReceived.mkdirs();
            }
        }
    }

    @Scheduled(fixedRate=5000L)
    public void poll() throws Exception {
        if (StringUtils.isBlank((CharSequence)this.pollingPath)) {
            return;
        }
        String pollingReceivedPath = this.pollingPath + "/received";
        Collection allFilesInPollFolder = FileUtils.listFiles((File)new File(this.pollingPath), (IOFileFilter)Utils.filesWhichCanBeProcessedFilter, null);
        if (allFilesInPollFolder.size() > 0) {
            for (File polledFile : allFilesInPollFolder) {
                if (this.jobsService.state.numberOfActiveJobs > 0) {
                    return;
                }
                String polledFilePath = polledFile.getAbsolutePath();
                String baseName = FilenameUtils.getBaseName((String)polledFilePath);
                String extension = FilenameUtils.getExtension((String)polledFilePath);
                String randomUUID = UUID.randomUUID().toString();
                String polledFileName = baseName + "-" + randomUUID + "." + extension;
                Collection processingFiles = FileUtils.listFiles((File)new File(pollingReceivedPath), (IOFileFilter)Utils.filesWhichCanBeProcessedFilter, null);
                this.jobsService.state.numberOfActiveJobs = processingFiles.size();
                if (!this.waitQueue.contains(polledFilePath)) {
                    this.waitQueue.add(polledFilePath);
                    continue;
                }
                String filePathToProcess = pollingReceivedPath + "/" + polledFileName;
                this.jobsService.state.numberOfActiveJobs = 1;
                File fileToProcess = new File(filePathToProcess);
                FileUtils.moveFile((File)polledFile, (File)fileToProcess);
                this.shellService.runDocumentBursterBatScriptFile("burst \"" + filePathToProcess + "\"", file -> {
                    List progressFile = this.jobsService.fetchStats().filter(f -> f.fileName.endsWith(".progress") && f.fileContent.contains(filePathToProcess)).collect(Collectors.toList());
                    if (Objects.isNull(progressFile) || progressFile.size() == 0) {
                        FileUtils.forceDelete((File)file);
                    }
                    this.waitQueue.remove(polledFilePath);
                    this.jobsService.state.numberOfActiveJobs = 0;
                }, fileToProcess);
            }
        }
    }
}

