/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.jobman.schedulers;

import com.flowkraft.jobman.models.WebSocketJobsExecutionStatsInfo;
import com.flowkraft.jobman.services.JobsService;
import com.flowkraft.jobman.services.LogsService;
import jakarta.annotation.PostConstruct;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class JobManScheduler {
    @Value(value="${ELECTRON_PID:}")
    private String parentElectronPid;
    @Autowired
    JobsService jobsService;
    @Autowired
    LogsService logsService;
    @Autowired
    private SimpMessageSendingOperations messagingTemplate;
    private final ConfigurableApplicationContext context;

    public JobManScheduler(ConfigurableApplicationContext context) {
        this.context = context;
    }

    @Scheduled(fixedRate=250L)
    public void publishExecutionStatsDetailsToWebSocket() throws Exception {
        if (StringUtils.isNotBlank((CharSequence)this.parentElectronPid)) {
            String line;
            long pid = Long.parseLong(this.parentElectronPid);
            Process process = Runtime.getRuntime().exec("tasklist /FI \"PID eq " + pid + "\"");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            boolean isRunning = false;
            while ((line = reader.readLine()) != null && !isRunning) {
                if (!line.contains(String.valueOf(pid))) continue;
                isRunning = true;
            }
            if (!isRunning) {
                int exitCode = SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0});
                System.exit(exitCode);
            }
        }
        WebSocketJobsExecutionStatsInfo execStatsMessageInfo = new WebSocketJobsExecutionStatsInfo("stats.jobs", this.jobsService.fetchStats());
        this.messagingTemplate.convertAndSend((Object)"/topic/execution-stats", (Object)execStatsMessageInfo);
        execStatsMessageInfo = new WebSocketJobsExecutionStatsInfo("stats.logs", this.logsService.ls());
        this.messagingTemplate.convertAndSend((Object)"/topic/execution-stats", (Object)execStatsMessageInfo);
    }

    @PostConstruct
    public void killAnyHangedElectronProcesses() throws Exception {
    }
}

