/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.jobman.controllers;

import com.flowkraft.common.AppPaths;
import com.flowkraft.common.Utils;
import com.flowkraft.jobman.models.FileInfo;
import com.flowkraft.jobman.services.SystemService;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import reactor.core.publisher.Flux;

@RestController
@RequestMapping(value={"/api/jobman"}, produces={"application/json"}, consumes={"multipart/form-data"})
public class UploadController {
    @Autowired
    SystemService systemService;

    @PostMapping(value={"/upload/process-multiple"})
    public Flux<FileInfo> handleUploadProcessMultipleFiles(@RequestPart(value="files") MultipartFile[] files) throws Exception {
        ArrayList<FileInfo> filesToProcess = new ArrayList<FileInfo>();
        String directoryName = UUID.randomUUID().toString();
        for (MultipartFile filePart : files) {
            String originalFilename = filePart.getOriginalFilename();
            String uploadedFilePath = AppPaths.UPLOADS_DIR_PATH + "/" + directoryName + "/" + originalFilename;
            File uploadedFile = new File(uploadedFilePath);
            FileUtils.createParentDirectories((File)uploadedFile);
            try (InputStream in = filePart.getInputStream();){
                Files.copy(in, uploadedFile.toPath(), new CopyOption[0]);
            }
            FileInfo fileInfo = new FileInfo(originalFilename, "", false);
            fileInfo.filePath = uploadedFilePath;
            filesToProcess.add(fileInfo);
        }
        return Flux.fromStream(filesToProcess.stream());
    }

    @PostMapping(value={"/upload/process-single"})
    public Flux<FileInfo> handleUploadProcessSingleFile(@RequestPart(value="file") MultipartFile multipPartFile) throws Exception {
        String originalFilename = multipPartFile.getOriginalFilename();
        String directoryName = UUID.randomUUID().toString();
        String uploadedFilePath = AppPaths.UPLOADS_DIR_PATH + "/" + directoryName + "/" + originalFilename;
        File uploadedFile = new File(uploadedFilePath);
        FileUtils.createParentDirectories((File)uploadedFile);
        try (InputStream in = multipPartFile.getInputStream();){
            Files.copy(in, uploadedFile.toPath(), new CopyOption[0]);
        }
        List uploadedFiles = Utils.getFilesToProcess((String)directoryName, (String)AppPaths.UPLOADS_DIR_PATH);
        return Flux.fromStream(uploadedFiles.stream());
    }

    @PostMapping(value={"/upload/process-qa"})
    public Flux<FileInfo> handleUploadQa(@RequestPart(value="file") MultipartFile multipPartFile) throws Exception {
        String originalFilename = multipPartFile.getOriginalFilename();
        String directoryName = UUID.randomUUID().toString();
        String uploadedFilePath = AppPaths.UPLOADS_DIR_PATH + "/" + directoryName + "/" + originalFilename;
        File uploadedFile = new File(uploadedFilePath);
        FileUtils.createParentDirectories((File)uploadedFile);
        try (InputStream in = multipPartFile.getInputStream();){
            Files.copy(in, uploadedFile.toPath(), new CopyOption[0]);
        }
        List uploadedFiles = Utils.getFilesToProcess((String)directoryName, (String)AppPaths.UPLOADS_DIR_PATH);
        return Flux.fromStream(uploadedFiles.stream());
    }
}

