/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.jobman.controllers;

import com.flowkraft.jobman.dtos.ExecuteCommandRequestDto;
import com.flowkraft.jobman.dtos.ExecuteCommandResponseDto;
import com.flowkraft.jobman.dtos.StarterPackStatusDto;
import com.flowkraft.jobman.services.StarterPacksManagementService;
import jakarta.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/api/jobman/starter-packs"}, produces={"application/json"}, consumes={"application/json"})
public class StarterPacksController {
    private static final Logger log = LoggerFactory.getLogger(StarterPacksController.class);
    private final StarterPacksManagementService starterPacksManagementService;

    @Autowired
    public StarterPacksController(StarterPacksManagementService starterPacksManagementService) {
        this.starterPacksManagementService = starterPacksManagementService;
    }

    @GetMapping(value={"/status"})
    public Flux<StarterPackStatusDto> getAllStarterPackStatuses() {
        log.info("Received request for all starter pack statuses.");
        return this.starterPacksManagementService.getAllStatuses().doOnError(e -> log.error("Error fetching starter pack statuses", e)).onErrorResume(e -> Flux.error((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Failed to retrieve starter pack statuses", e)));
    }

    @PostMapping(value={"/execute"})
    public Mono<ResponseEntity<ExecuteCommandResponseDto>> executeStarterPackCommand(@Valid @RequestBody ExecuteCommandRequestDto request) {
        log.info("Received request to execute starter pack command: [{}]", (Object)request.getCommand());
        if (request.getCommand() == null || request.getCommand().trim().isEmpty()) {
            log.warn("Received empty command in execute request.");
            ExecuteCommandResponseDto errorResponse = new ExecuteCommandResponseDto("Error: Command cannot be empty.", "error");
            return Mono.just((Object)ResponseEntity.badRequest().body((Object)errorResponse));
        }
        return this.starterPacksManagementService.executeCommand(request.getCommand()).map(response -> {
            log.info("Command execution successful (immediate result): Status={}, Output='{}'", (Object)response.getNewStatus(), (Object)response.getOutput());
            return ResponseEntity.ok((Object)response);
        }).doOnError(e -> log.error("Error executing starter pack command: [{}]", (Object)request.getCommand(), e)).onErrorResume(e -> {
            ExecuteCommandResponseDto errorResponse = new ExecuteCommandResponseDto("Error executing command: " + e.getMessage(), "error");
            return Mono.just((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)errorResponse));
        });
    }
}

