/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.jobman.controllers;

import com.flowkraft.common.AppPaths;
import com.flowkraft.jobman.dtos.ReportFullConfigDto;
import com.flowkraft.jobman.services.ReportingService;
import com.sourcekraft.documentburster.common.chart.ChartOptions;
import com.sourcekraft.documentburster.common.chart.ChartOptionsParser;
import com.sourcekraft.documentburster.common.db.ReportDataResult;
import com.sourcekraft.documentburster.common.pivottable.PivotTableOptions;
import com.sourcekraft.documentburster.common.pivottable.PivotTableOptionsParser;
import com.sourcekraft.documentburster.common.reportparameters.ReportParameter;
import com.sourcekraft.documentburster.common.reportparameters.ReportParametersHelper;
import com.sourcekraft.documentburster.common.tabulator.TabulatorOptions;
import com.sourcekraft.documentburster.common.tabulator.TabulatorOptionsParser;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/api/jobman/reporting"}, produces={"application/json"}, consumes={"application/json"})
public class ReportingController {
    private static final Logger log = LoggerFactory.getLogger(ReportingController.class);
    ReportingService reportingService;

    @Autowired
    public ReportingController(ReportingService reportingService) {
        this.reportingService = reportingService;
    }

    @PostMapping(value={"/parse-parameters"})
    public Mono<List<ReportParameter>> processGroovyParameters(@RequestBody String groovyParametersDslCode) {
        String cleanedCode = groovyParametersDslCode.replaceAll("^\"|\"$", "").replace("\\n", "\n").replace("\\t", "\t").replace("\\\"", "\"");
        return Mono.fromCallable(() -> {
            List reportParameters = ReportParametersHelper.parseGroovyParametersDslCode((String)cleanedCode);
            return reportParameters;
        }).doOnError(e -> log.error("Error parsing report parameters", e)).onErrorResume(e -> Mono.error((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Failed to parse report parameters", e)));
    }

    @PostMapping(value={"/parse-tabulator"})
    public Mono<TabulatorOptions> processGroovyTabulator(@RequestBody String groovyTabulatorDslCode) {
        String cleanedCode = groovyTabulatorDslCode.replaceAll("^\"|\"$", "").replace("\\n", "\n").replace("\\t", "\t").replace("\\\"", "\"");
        return Mono.fromCallable(() -> {
            TabulatorOptions opts = TabulatorOptionsParser.parseGroovyTabulatorDslCode((String)cleanedCode);
            return opts;
        }).doOnError(e -> log.error("Error parsing tabulator options", e)).onErrorResume(e -> Mono.error((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Failed to parse tabulator options", e)));
    }

    @PostMapping(value={"/parse-chart"})
    public Mono<ChartOptions> processGroovyChart(@RequestBody String groovyChartDslCode) {
        String cleanedCode = groovyChartDslCode.replaceAll("^\"|\"$", "").replace("\\n", "\n").replace("\\t", "\t").replace("\\\"", "\"");
        return Mono.fromCallable(() -> {
            ChartOptions opts = ChartOptionsParser.parseGroovyChartDslCode((String)cleanedCode);
            return opts;
        }).doOnError(e -> log.error("Error parsing chart options", e)).onErrorResume(e -> Mono.error((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Failed to parse chart options", e)));
    }

    @PostMapping(value={"/parse-pivot"})
    public Mono<PivotTableOptions> processGroovyPivotTable(@RequestBody String groovyPivotDslCode) {
        String cleanedCode = groovyPivotDslCode.replaceAll("^\"|\"$", "").replace("\\n", "\n").replace("\\t", "\t").replace("\\\"", "\"");
        return Mono.fromCallable(() -> {
            PivotTableOptions opts = PivotTableOptionsParser.parseGroovyPivotTableDslCode((String)cleanedCode);
            return opts;
        }).doOnError(e -> log.error("Error parsing pivot table options", e)).onErrorResume(e -> Mono.error((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Failed to parse pivot table options", e)));
    }

    @GetMapping(value={"/fetch-data"})
    public Mono<ReportDataResult> fetchData(@RequestParam String configurationFilePath, @RequestParam Map<String, String> parameters) {
        return Mono.fromCallable(() -> {
            String cfgFilePath = Paths.get(configurationFilePath, new String[0]).isAbsolute() ? configurationFilePath : Paths.get(AppPaths.PORTABLE_EXECUTABLE_DIR_PATH, configurationFilePath).toString();
            parameters.forEach((key, value) -> {});
            ReportDataResult result = this.reportingService.fetchData(cfgFilePath, parameters);
            return result;
        }).doOnSuccess(result -> {}).doOnError(e -> log.error("Error fetching data", e)).onErrorResume(e -> Mono.error((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Failed to fetch data", e)));
    }

    @GetMapping(value={"/reports/{reportCode}/config"}, consumes={"*/*"})
    public Mono<ReportFullConfigDto> getReportConfig(@PathVariable String reportCode) {
        System.out.println("[DEBUG] GET /reports/" + reportCode + "/config - ENTERING");
        return Mono.fromCallable(() -> {
            System.out.println("[DEBUG] GET /reports/" + reportCode + "/config - calling reportingService.loadReportConfig");
            ReportFullConfigDto result = this.reportingService.loadReportConfig(reportCode);
            System.out.println("[DEBUG] GET /reports/" + reportCode + "/config - SUCCESS, hasTabulator=" + result.hasTabulator);
            return result;
        }).doOnError(e -> {
            System.out.println("[DEBUG] GET /reports/" + reportCode + "/config - ERROR: " + e.getMessage());
            e.printStackTrace();
            log.error("Error loading report config for: " + reportCode, e);
        }).onErrorResume(e -> Mono.error((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Failed to load report config", e)));
    }

    @GetMapping(value={"/reports/{reportCode}/data"}, consumes={"*/*"})
    public Mono<ReportDataResult> fetchReportData(@PathVariable String reportCode, @RequestParam Map<String, String> parameters) {
        System.out.println("[DEBUG] GET /reports/" + reportCode + "/data - ENTERING, params=" + String.valueOf(parameters));
        return Mono.fromCallable(() -> {
            System.out.println("[DEBUG] GET /reports/" + reportCode + "/data - calling reportingService.fetchReportData");
            ReportDataResult result = this.reportingService.fetchReportData(reportCode, parameters);
            System.out.println("[DEBUG] GET /reports/" + reportCode + "/data - SUCCESS, rows=" + String.valueOf(result.reportData != null ? Integer.valueOf(result.reportData.size()) : "null"));
            return result;
        }).doOnError(e -> {
            System.out.println("[DEBUG] GET /reports/" + reportCode + "/data - ERROR: " + e.getMessage());
            e.printStackTrace();
            log.error("Error fetching report data for: " + reportCode, e);
        }).onErrorResume(e -> Mono.error((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Failed to fetch report data", e)));
    }
}

