/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.common;

import com.flowkraft.common.Ant;
import com.flowkraft.common.Utils;
import com.flowkraft.jobman.models.FileInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

public class Utils {
    public static IOFileFilter filesWhichCanBeProcessedFilter = FileFilterUtils.asFileFilter(file -> {
        String lowerCaseFileName = file.getName().toLowerCase();
        String extension = FilenameUtils.getExtension((String)lowerCaseFileName);
        return extension.equals("pdf") || extension.equals("xls") || extension.equals("xlsx");
    });

    public static <T> Consumer<T> uncheckedConsumer(CheckedConsumer<T> consumer) {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static void emptyFile(String filePath) throws Exception {
        FileUtils.write((File)new File(filePath), (CharSequence)"", (Charset)Charset.defaultCharset());
    }

    public static String encodeURIComponent(String s) throws Exception {
        return URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
    }

    public static String getProductName() {
        if (new File("startServer.bat").exists() || new File("startServer.sh").exists()) {
            return "DocumentBurster Server";
        }
        return "DocumentBurster";
    }

    public static List<FileInfo> getFilesToProcess(String transactionId, String folderPath) {
        FileSet fs = new FileSet();
        fs.setDir(new File(folderPath));
        fs.setIncludes(transactionId + "/*.*");
        DirectoryScanner ds = fs.getDirectoryScanner(Ant.proj);
        List<String> dsFiles = Arrays.asList(ds.getIncludedFiles());
        ArrayList<FileInfo> filesToProcess = new ArrayList<FileInfo>();
        dsFiles.forEach(fName -> {
            FileInfo fileInfo = new FileInfo(fName, "", false);
            fileInfo.filePath = folderPath + "/" + fName;
            filesToProcess.add(fileInfo);
        });
        return filesToProcess;
    }

    public static String getJvmArgumentValue(String argumentId) {
        String value = "";
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        for (String argument : runtimeMxBean.getInputArguments()) {
            if (!StringUtils.isBlank((CharSequence)value) || !argument.startsWith(argumentId)) continue;
            value = argument.substring(argumentId.length());
        }
        return value;
    }

    public static List<Long> getPidsOfProcessesOfExecutableRunning(String executableName) throws Exception {
        ArrayList<Long> pids = new ArrayList<Long>();
        ProcessBuilder processBuilder = new ProcessBuilder("wmic", "process", "where", "(ExecutablePath like '%" + executableName + "')", "get", "ExecutablePath,ProcessId");
        Process process = processBuilder.start();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parts;
                if ((line = line.trim()).isEmpty() || line.equalsIgnoreCase("ExecutablePath  ProcessId") || (parts = line.split("\\s+")).length != 2 || !parts[0].toLowerCase().endsWith(executableName.toLowerCase())) continue;
                pids.add(Long.parseLong(parts[1]));
            }
        }
        return pids;
    }

    public static String getProcessExecutablePath(Long pid) throws Exception {
        String line;
        Process process = Runtime.getRuntime().exec("wmic process where processid=" + pid + " get ExecutablePath");
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            if (line.trim().isEmpty() || line.trim().equals("ExecutablePath")) continue;
            String executablePath = line.trim();
            return executablePath;
        }
        return "";
    }

    public static String getProcessCreationDate(long pid) throws Exception {
        String line;
        Process process = Runtime.getRuntime().exec("wmic process where processid=" + pid + " get CreationDate");
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).isEmpty() || line.equals("CreationDate")) continue;
            return line;
        }
        return "";
    }
}

