/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.cfgman;

import com.flowkraft.cfgman.DocumentBursterSettingsService;
import com.flowkraft.common.AppPaths;
import com.flowkraft.common.Utils;
import com.flowkraft.jobman.services.IOUtilsService;
import com.flowkraft.jobman.services.SystemService;
import com.sourcekraft.documentburster.common.settings.Settings;
import com.sourcekraft.documentburster.common.settings.model.ConfigurationFileInfo;
import com.sourcekraft.documentburster.common.settings.model.ConnectionFileInfo;
import com.sourcekraft.documentburster.common.settings.model.DocumentBursterConnectionDatabaseSettings;
import com.sourcekraft.documentburster.common.settings.model.DocumentBursterConnectionEmailSettings;
import com.sourcekraft.documentburster.common.settings.model.DocumentBursterSettings;
import com.sourcekraft.documentburster.common.settings.model.DocumentBursterSettingsInternal;
import com.sourcekraft.documentburster.common.settings.model.ReportingSettings;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/api/cfgman"})
public class CfgManController {
    @Autowired
    DocumentBursterSettingsService rbSettingsService;
    @Autowired
    SystemService systemService;
    @Autowired
    IOUtilsService ioUtilsService;

    @GetMapping(value={"/rb/load-all"})
    public Flux<ConfigurationFileInfo> loadRbSettingsAll() throws Exception {
        return Flux.fromStream((Stream)this.rbSettingsService.loadSettingsAll());
    }

    @GetMapping(value={"/rb/load-all-minimal"})
    public Flux<ConfigurationFileInfo> loadRbSettingsAllMinimal() throws Exception {
        return Flux.fromStream((Stream)this.rbSettingsService.loadSettingsAllMinimal());
    }

    @GetMapping(value={"/rb/load-config-details"})
    public Mono<ConfigurationFileInfo> loadConfigDetails(@RequestParam String path) throws Exception {
        String decodedPath = URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
        ConfigurationFileInfo details = this.rbSettingsService.loadConfigDetails(decodedPath);
        return details != null ? Mono.just((Object)details) : Mono.empty();
    }

    @GetMapping(value={"/rb/load"})
    public Mono<DocumentBursterSettings> loadRbSettings(@RequestParam String path) throws Exception {
        String fullPath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/" + URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
        DocumentBursterSettings dbSettings = this.rbSettingsService.loadSettings(fullPath);
        return Mono.just((Object)dbSettings);
    }

    @PostMapping(value={"/rb/save"})
    public void saveRbSettings(@RequestParam String path, @RequestBody DocumentBursterSettings dbSettings) throws Exception {
        String fullPath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/" + URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
        this.rbSettingsService.saveSettings(dbSettings, fullPath);
    }

    @GetMapping(value={"/rb/load-reporting"})
    public Mono<ReportingSettings> loadRbSettingsReporting(@RequestParam String path) throws Exception {
        String fullPath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/" + URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
        return Mono.just((Object)this.rbSettingsService.loadSettingsReporting(fullPath));
    }

    @PostMapping(value={"/rb/save-reporting"})
    public void saveRbReportSettingsReporting(@RequestParam String path, @RequestBody ReportingSettings dbSettings) throws Exception {
        String fullPath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/" + URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
        this.rbSettingsService.saveSettingsReporting(dbSettings, fullPath);
    }

    @GetMapping(value={"/rb/load-connection-email-all"})
    public Flux<ConnectionFileInfo> loadRbSettingsConnectionEmailAll() throws Exception {
        return Flux.fromStream((Stream)this.rbSettingsService.loadSettingsConnectionEmailAll());
    }

    @GetMapping(value={"/rb/load-connection-email"})
    public Mono<DocumentBursterConnectionEmailSettings> loadRbSettingsConnectionEmail(@RequestParam String path) throws Exception {
        String fullPath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/" + URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
        return Mono.just((Object)this.rbSettingsService.loadSettingsConnectionEmail(fullPath));
    }

    @PostMapping(value={"/rb/save-connection-email"})
    public void saveRbReportSettingsConnection(@RequestParam String path, @RequestBody DocumentBursterConnectionEmailSettings dbSettings) throws Exception {
        String decodedPath = URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
        Path requestedPath = Paths.get(decodedPath, new String[0]);
        String fullPath = requestedPath.isAbsolute() ? decodedPath : Paths.get(AppPaths.PORTABLE_EXECUTABLE_DIR_PATH, decodedPath).toString();
        this.rbSettingsService.saveSettingsConnectionEmail(dbSettings, fullPath);
    }

    @GetMapping(value={"/rb/load-connection-database-all"})
    public Flux<ConnectionFileInfo> loadRbSettingsConnectionDatabaseAll() throws Exception {
        return Flux.fromStream((Stream)this.rbSettingsService.loadSettingsConnectionDatabaseAll());
    }

    @GetMapping(value={"/rb/load-connection-database"})
    public Mono<DocumentBursterConnectionDatabaseSettings> loadRbSettingsConnectionDatabase(@RequestParam String path) throws Exception {
        String fullPath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/" + URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
        return Mono.just((Object)this.rbSettingsService.loadSettingsConnectionDatabase(fullPath));
    }

    @PostMapping(value={"/rb/save-connection-database"})
    public void saveRbSettingsConnectionDatabase(@RequestParam String path, @RequestBody DocumentBursterConnectionDatabaseSettings dbSettings) throws Exception {
        String decodedPath = URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
        Path requestedPath = Paths.get(decodedPath, new String[0]);
        String fullPath = requestedPath.isAbsolute() ? decodedPath : Paths.get(AppPaths.PORTABLE_EXECUTABLE_DIR_PATH, decodedPath).toString();
        this.rbSettingsService.saveSettingsConnectionDatabase(dbSettings, fullPath);
    }

    @GetMapping(value={"/rb/load-internal"})
    public Mono<DocumentBursterSettingsInternal> loadRbSettingsInternal(@RequestParam String path) throws Exception {
        String fullPath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/" + URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
        return Mono.just((Object)this.rbSettingsService.loadSettingsInternal(fullPath));
    }

    @PostMapping(value={"/rb/save-internal"})
    public void saveRbSettingsInternal(@RequestParam String path, @RequestBody DocumentBursterSettingsInternal dbSettingsInternal) throws Exception {
        String fullPath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/" + URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
        this.rbSettingsService.saveSettingsInternal(dbSettingsInternal, fullPath);
    }

    @GetMapping(value={"/rb/load-templates-all"})
    public Flux<ConfigurationFileInfo> loadRbTemplatesAll() throws Exception {
        return Flux.fromStream((Stream)this.rbSettingsService.loadRbTemplatesAll());
    }

    @PostMapping(value={"/rb/save-template"}, consumes={"text/plain"})
    Mono<Void> saveTemplate(@RequestParam String path, @RequestBody Optional<String> content) throws Exception {
        String fullPath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/" + URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
        return Mono.fromCallable(() -> {
            this.systemService.fsWriteStringToFile(fullPath, content);
            return null;
        });
    }

    @GetMapping(value={"/rb/load-template"}, produces={"text/plain"})
    Mono<String> readFileToString(@RequestParam String path) throws Exception {
        String decodedPath = URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
        Path requestedPath = Paths.get(decodedPath, new String[0]);
        String fullPath = requestedPath.isAbsolute() ? decodedPath : Paths.get(AppPaths.PORTABLE_EXECUTABLE_DIR_PATH, decodedPath).toString();
        String fileContent = this.systemService.unixCliCat(fullPath);
        return Mono.just((Object)(fileContent != null ? fileContent : ""));
    }

    @GetMapping(value={"/rb/serve-asset"}, produces={"*/*"})
    public Mono<ResponseEntity<?>> serveAsset(@RequestParam String path) throws Exception {
        String fullPath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/" + URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
        String contentType = this.determineContentType(fullPath);
        if (!contentType.startsWith("text/")) {
            return Mono.fromCallable(() -> {
                byte[] fileData = this.ioUtilsService.readBinaryFile(fullPath);
                return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", new String[]{contentType})).header("Accept", new String[]{"*/*"})).body((Object)fileData);
            });
        }
        return Mono.fromCallable(() -> {
            String fileContent = this.systemService.unixCliCat(fullPath);
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", new String[]{contentType})).header("Accept", new String[]{"*/*"})).body((Object)fileContent);
        });
    }

    @GetMapping(value={"/rb/view-template"}, produces={"text/html"})
    public Mono<ResponseEntity<String>> viewTemplate(@RequestParam String path) throws Exception {
        String fullPath = AppPaths.PORTABLE_EXECUTABLE_DIR_PATH + "/" + URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
        boolean isXml = path.toLowerCase().endsWith(".xml");
        return Mono.fromCallable(() -> {
            String htmlContent = "";
            if (isXml) {
                Settings settings = new Settings(fullPath);
                settings.loadSettings();
                htmlContent = settings.getEmailSettings().html;
                if (htmlContent == null) {
                    htmlContent = "<!-- No HTML email content found in XML -->";
                }
            } else {
                htmlContent = this.systemService.unixCliCat(fullPath);
            }
            String baseDir = path.substring(0, path.lastIndexOf(47) + 1);
            Document doc = Jsoup.parse((String)htmlContent);
            Elements images = doc.select("img[src]");
            for (Object img : images) {
                String src = img.attr("src");
                if (src.startsWith("http") || src.startsWith("data:") || src.startsWith("/api/")) continue;
                src = src.replaceFirst("^\\./", "");
                img.attr("src", "/api/cfgman/rb/serve-asset?path=" + Utils.encodeURIComponent((String)(baseDir + src)));
            }
            Elements links = doc.select("link[href]");
            for (Object link : links) {
                String href = link.attr("href");
                if (href.startsWith("http") || href.startsWith("data:") || href.startsWith("/api/")) continue;
                href = href.replaceFirst("^\\./", "");
                link.attr("href", "/api/cfgman/rb/serve-asset?path=" + Utils.encodeURIComponent((String)(baseDir + href)));
            }
            Elements styles = doc.select("style");
            for (Object style : styles) {
                String css = style.html();
                Pattern bgPattern = Pattern.compile("background-image:\\s*url\\(['\"]((?!http|data:|/api)[^'\"]*)['\"]*\\)");
                Matcher bgMatcher = bgPattern.matcher(css);
                StringBuffer bgSb = new StringBuffer();
                while (bgMatcher.find()) {
                    String path1 = bgMatcher.group(1).replaceFirst("^\\./", "");
                    bgMatcher.appendReplacement(bgSb, "background-image: url('/api/cfgman/rb/serve-asset?path=" + baseDir + path1 + "')");
                }
                bgMatcher.appendTail(bgSb);
                css = bgSb.toString();
                Pattern fontPattern = Pattern.compile("src:\\s*url\\(['\"]((?!http|data:|/api)[^'\"]*)['\"]*\\)");
                Matcher fontMatcher = fontPattern.matcher(css);
                StringBuffer fontSb = new StringBuffer();
                while (fontMatcher.find()) {
                    String path1 = fontMatcher.group(1).replaceFirst("^\\./", "");
                    fontMatcher.appendReplacement(fontSb, "src: url('/api/cfgman/rb/serve-asset?path=" + baseDir + path1 + "')");
                }
                fontMatcher.appendTail(fontSb);
                css = fontSb.toString();
                style.html(css);
            }
            Elements elementsWithStyle = doc.select("[style*=background-image]");
            for (Element el : elementsWithStyle) {
                String style = el.attr("style");
                Pattern pattern = Pattern.compile("background-image:\\s*url\\(['\"]((?!http|data:|/api)[^'\"]*)['\"]*\\)");
                Matcher matcher = pattern.matcher(style);
                StringBuffer sb = new StringBuffer();
                while (matcher.find()) {
                    String path1 = matcher.group(1).replaceFirst("^\\./", "");
                    matcher.appendReplacement(sb, "background-image: url('/api/cfgman/rb/serve-asset?path=" + baseDir + path1 + "')");
                }
                matcher.appendTail(sb);
                el.attr("style", sb.toString());
            }
            String processedHtml = doc.outerHtml();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", new String[]{"text/html"})).body((Object)processedHtml);
        });
    }

    private String determineContentType(String filePath) {
        String extension = "";
        int i = filePath.lastIndexOf(46);
        if (i > 0) {
            extension = filePath.substring(i + 1).toLowerCase();
        }
        switch (extension) {
            case "png": {
                return "image/png";
            }
            case "jpg": 
            case "jpeg": {
                return "image/jpeg";
            }
            case "gif": {
                return "image/gif";
            }
            case "svg": {
                return "image/svg+xml";
            }
            case "webp": {
                return "image/webp";
            }
            case "ico": {
                return "image/x-icon";
            }
            case "bmp": {
                return "image/bmp";
            }
            case "woff": {
                return "font/woff";
            }
            case "woff2": {
                return "font/woff2";
            }
            case "ttf": {
                return "font/ttf";
            }
            case "eot": {
                return "application/vnd.ms-fontobject";
            }
            case "otf": {
                return "font/otf";
            }
            case "css": {
                return "text/css";
            }
            case "js": {
                return "application/javascript";
            }
            case "json": {
                return "application/json";
            }
            case "xml": {
                return "application/xml";
            }
            case "html": 
            case "htm": {
                return "text/html";
            }
            case "txt": {
                return "text/plain";
            }
        }
        return "application/octet-stream";
    }
}

