/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;

class NIOControlPacket
extends NIOPacket {
    short nsControlCommand;
    static final short NSPCTL_SERR = 8;
    static final short NSPCTL_CLRATTN = 9;
    static final int ORA_ERROR_EMFI_NUMBER = 22;
    static final int NSECMANSHUT = 12572;
    static final int NSESENDMESG = 12573;

    NIOControlPacket(SessionAtts session) {
        super(session);
        this.header.type = 10;
    }

    @Override
    void readPayloadBuffer() throws IOException {
        this.nsControlCommand = this.session.payloadBufferForRead.getShort();
        if (this.nsControlCommand == 8) {
            this.processNSError();
        } else if (this.nsControlCommand == 9) {
            this.disableAttentionProcessing();
        }
    }

    private void processNSError() throws IOException {
        int emfiNumber = this.session.payloadBufferForRead.getInt();
        int primaryErrorNumber = this.session.payloadBufferForRead.getInt();
        int secondaryErrorNumber = this.session.payloadBufferForRead.getInt();
        if (primaryErrorNumber == 12572 || primaryErrorNumber == 12573) {
            this.session.needsToBeClosed = true;
            return;
        }
        if (emfiNumber == 22) {
            throw new NetException(primaryErrorNumber, null, true);
        }
        throw new NetException(primaryErrorNumber, "TNS-" + primaryErrorNumber, true);
    }

    private void disableAttentionProcessing() {
        this.session.negotiatedOptions &= 0xFFFFFDFF;
        this.session.negotiatedOptions &= 0xFFFFFBFF;
        this.session.setNetProperty("oracle.jdbc.isOOBEnabled", "false");
    }
}

