/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.zip;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.dflib.ByteSource;
import org.dflib.ByteSources;
import org.dflib.zip.ZipStreamByteSource;

class ZipStreamByteSources
implements ByteSources {
    private final ByteSource zipSource;

    public ZipStreamByteSources(ByteSource zipSource) {
        this.zipSource = zipSource;
    }

    @Override
    public <T> Map<String, T> process(BiFunction<String, ByteSource, T> processor) {
        HashMap<String, T> result = new HashMap<String, T>();
        try (ZipInputStream in = new ZipInputStream(this.zipSource.stream());){
            ZipEntry entry;
            while ((entry = in.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                T val = processor.apply(entry.getName(), new ZipStreamByteSource(in, entry.getName()));
                result.put(entry.getName(), val);
                in.closeEntry();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading ZIP stream", e);
        }
        return result;
    }
}

