/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.dflib.ByteSource;

class ZipFileByteSource
implements ByteSource {
    private final ZipFile zipFile;
    private final ZipEntry zipEntry;

    public ZipFileByteSource(ZipFile zipFile, ZipEntry zipEntry) {
        this.zipEntry = zipEntry;
        this.zipFile = zipFile;
    }

    @Override
    public Optional<String> uri() {
        return Optional.of(this.zipEntry.getName());
    }

    public ZipEntry getZipEntry() {
        return this.zipEntry;
    }

    @Override
    public InputStream stream() {
        try {
            return this.zipFile.getInputStream(this.zipEntry);
        }
        catch (IOException e) {
            throw new RuntimeException("Error getting a stream for zip entry: " + this.zipEntry.getName(), e);
        }
    }
}

