/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.window;

import java.util.Objects;
import org.dflib.DataFrame;

public class WindowRange {
    private final int startOffsetInclusive;
    private final int endOffsetInclusive;
    public static final WindowRange allPreceding = new WindowRange(Integer.MAX_VALUE, 0){

        @Override
        public boolean alwaysInRange(int height) {
            return height <= 1;
        }
    };
    public static final WindowRange allFollowing = new WindowRange(0, 0x7FFFFFFE){

        @Override
        public boolean alwaysInRange(int height) {
            return height <= 1;
        }
    };
    public static final WindowRange all = new WindowRange(Integer.MAX_VALUE, 0x7FFFFFFE){

        @Override
        public boolean alwaysInRange(int height) {
            return true;
        }
    };

    public static WindowRange of(int startOffsetInclusive, int endOffsetInclusive) {
        return new WindowRange(startOffsetInclusive, endOffsetInclusive);
    }

    protected WindowRange(int startOffsetInclusive, int endOffsetInclusive) {
        if (startOffsetInclusive < 0) {
            throw new IllegalArgumentException("'startOffsetInclusive' must be non-negative: " + startOffsetInclusive);
        }
        if (endOffsetInclusive < 0) {
            throw new IllegalArgumentException("'endOffsetInclusive' must be non-negative: " + endOffsetInclusive);
        }
        this.startOffsetInclusive = startOffsetInclusive;
        this.endOffsetInclusive = endOffsetInclusive;
    }

    public boolean alwaysInRange(int height) {
        return height <= 1 ? true : this.startOffsetInclusive >= height - 1 && this.endOffsetInclusive >= height - 1;
    }

    public int rowOffset(int rowIndex) {
        if (rowIndex < 0) {
            throw new ArrayIndexOutOfBoundsException("Negative row index: " + rowIndex);
        }
        int fromInclusive = Math.max(0, rowIndex - this.startOffsetInclusive);
        return rowIndex - fromInclusive;
    }

    public DataFrame selectRows(DataFrame dataFrame, int rowIndex) {
        int h = dataFrame.height();
        if (rowIndex < 0) {
            throw new ArrayIndexOutOfBoundsException("Negative row index: " + rowIndex);
        }
        if (rowIndex >= h) {
            throw new ArrayIndexOutOfBoundsException("Row index higher than the DataFrame height: " + rowIndex);
        }
        int fromInclusive = Math.max(0, rowIndex - this.startOffsetInclusive);
        int delta = this.endOffsetInclusive - h;
        int toExclusive = delta <= 0 ? Math.min(h, rowIndex + this.endOffsetInclusive + 1) : h;
        return dataFrame.rowsRange(fromInclusive, toExclusive).select();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowRange that = (WindowRange)o;
        return this.startOffsetInclusive == that.startOffsetInclusive && this.endOffsetInclusive == that.endOffsetInclusive;
    }

    public int hashCode() {
        return Objects.hash(this.startOffsetInclusive, this.endOffsetInclusive);
    }
}

