/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.window;

import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.dflib.ColumnDataFrame;
import org.dflib.DataFrame;
import org.dflib.Exp;
import org.dflib.GroupBy;
import org.dflib.Hasher;
import org.dflib.Index;
import org.dflib.IntSeries;
import org.dflib.Series;
import org.dflib.Sorter;
import org.dflib.exp.Exps;
import org.dflib.series.IntSequenceSeries;
import org.dflib.slice.ColumnSetMerger;
import org.dflib.slice.FixedColumnSetIndex;
import org.dflib.sort.Comparators;
import org.dflib.sort.DataFrameSorter;
import org.dflib.sort.IntComparator;
import org.dflib.window.DenseRanker;
import org.dflib.window.Ranker;
import org.dflib.window.RowNumberer;
import org.dflib.window.WindowColumnEvaluator;
import org.dflib.window.WindowRange;

public class Window {
    private final DataFrame source;
    private Hasher partitioner;
    private IntComparator sorter;
    private WindowRange range;
    private FixedColumnSetIndex columnSetIndex;

    public Window(DataFrame source) {
        this.source = Objects.requireNonNull(source);
    }

    public DataFrame getSource() {
        return this.source;
    }

    public Window cols(Predicate<String> colsPredicate) {
        Index srcIndex = this.source.getColumnsIndex();
        this.columnSetIndex = FixedColumnSetIndex.of(srcIndex, srcIndex.positions(colsPredicate));
        return this;
    }

    public Window cols(String ... cols) {
        this.columnSetIndex = FixedColumnSetIndex.of(cols);
        return this;
    }

    public Window cols(int ... cols) {
        Index srcIndex = this.source.getColumnsIndex();
        this.columnSetIndex = FixedColumnSetIndex.of(srcIndex, cols);
        return this;
    }

    public Window colsExcept(String ... cols) {
        return this.cols(this.source.getColumnsIndex().positionsExcept(cols));
    }

    public Window colsExcept(int ... cols) {
        return this.cols(this.source.getColumnsIndex().positionsExcept(cols));
    }

    public Window colsExcept(Predicate<String> colsPredicate) {
        return this.cols(colsPredicate.negate());
    }

    public Window partitioned(Hasher partitioner) {
        this.partitioner = Objects.requireNonNull(partitioner);
        return this;
    }

    public Window partitioned(String ... columns) {
        int len = columns.length;
        if (len == 0) {
            throw new IllegalArgumentException("No partitioning columns specified");
        }
        Hasher partitioner = Hasher.of(columns[0]);
        for (int i = 1; i < columns.length; ++i) {
            partitioner = partitioner.and(columns[i]);
        }
        this.partitioner = partitioner;
        return this;
    }

    public Window partitioned(int ... columns) {
        int len = columns.length;
        if (len == 0) {
            throw new IllegalArgumentException("No partitioning columns specified");
        }
        Hasher partitioner = Hasher.of(columns[0]);
        for (int i = 1; i < columns.length; ++i) {
            partitioner = partitioner.and(columns[i]);
        }
        this.partitioner = partitioner;
        return this;
    }

    public Window sorted(Sorter ... sorters) {
        this.sorter = sorters.length == 0 ? null : Comparators.of(this.source, sorters);
        return this;
    }

    public Window sorted(String column, boolean ascending) {
        this.sorter = Comparators.of(this.source.getColumn(column), ascending);
        return this;
    }

    public Window sorted(int column, boolean ascending) {
        this.sorter = Comparators.of(this.source.getColumn(column), ascending);
        return this;
    }

    public Window sorted(String[] columns, boolean[] ascending) {
        this.sorter = Comparators.of(this.source, columns, ascending);
        return this;
    }

    public Window sorted(int[] columns, boolean[] ascending) {
        this.sorter = Comparators.of(this.source, columns, ascending);
        return this;
    }

    public Window range(WindowRange range) {
        this.range = range;
        return this;
    }

    public DataFrame select(Exp<?> ... exps) {
        return new ColumnDataFrame(null, Index.ofDeduplicated(this.selectLabels(exps)), this.selectColumns(exps));
    }

    public DataFrame merge(Exp<?> ... exps) {
        String[] labels = this.selectLabels(exps);
        return ColumnSetMerger.merge(this.source, labels, this.selectColumns(exps));
    }

    public IntSeries rank() {
        switch (this.source.height()) {
            case 0: {
                return Series.ofInt(new int[0]);
            }
            case 1: {
                return Series.ofInt(1);
            }
        }
        return this.partitioner != null ? this.rankPartitioned() : this.rankUnPartitioned();
    }

    public IntSeries denseRank() {
        switch (this.source.height()) {
            case 0: {
                return Series.ofInt(new int[0]);
            }
            case 1: {
                return Series.ofInt(1);
            }
        }
        return this.partitioner != null ? this.denseRankPartitioned() : this.denseRankUnPartitioned();
    }

    public IntSeries rowNumber() {
        switch (this.source.height()) {
            case 0: {
                return Series.ofInt(new int[0]);
            }
            case 1: {
                return Series.ofInt(1);
            }
        }
        return this.partitioner != null ? this.rowNumberPartitioned() : this.rowNumberUnPartitioned();
    }

    public <T> Series<T> shift(String column, int offset) {
        return this.shift(column, offset, null);
    }

    public <T> Series<T> shift(String column, int offset, T filler) {
        int pos = this.source.getColumnsIndex().position(column);
        return this.shift(pos, offset, filler);
    }

    public <T> Series<T> shift(int column, int offset) {
        return this.shift(column, offset, null);
    }

    public <T> Series<T> shift(int column, int offset, T filler) {
        if (offset == 0) {
            return this.source.getColumn(column);
        }
        switch (this.source.height()) {
            case 0: {
                return Series.of(new Object[0]);
            }
            case 1: {
                return Series.of(filler);
            }
        }
        return this.partitioner != null ? this.shiftPartitioned(column, offset, filler) : this.shiftUnPartitioned(column, offset, filler);
    }

    private <T> Series<T> shiftPartitioned(int column, int offset, T filler) {
        GroupBy gb = this.source.group(this.partitioner);
        return this.sorter != null ? gb.sort(this.sorter).shift(column, offset, filler) : gb.shift(column, offset, filler);
    }

    private <T> Series<T> shiftUnPartitioned(int column, int offset, T filler) {
        if (this.sorter != null) {
            IntSequenceSeries index = new IntSequenceSeries(0, this.source.height());
            IntSeries sortedPositions = DataFrameSorter.sort(this.sorter, index);
            Series s = this.source.getColumn(column);
            return s.select(sortedPositions).shift(offset, filler).select(sortedPositions.sortIndexInt());
        }
        Series<T> s = this.source.getColumn(column);
        return s.shift(offset, filler);
    }

    private String[] selectLabels(Exp<?> ... aggregators) {
        return this.columnSetIndex != null ? this.columnSetIndex.getLabels() : Exps.labels(this.source, aggregators);
    }

    private Series<?>[] selectColumns(Exp<?> ... aggregators) {
        return this.partitioner != null ? this.selectPartitioned(aggregators) : this.selectUnPartitioned(aggregators);
    }

    private Series<?>[] selectPartitioned(Exp<?> ... aggregators) {
        GroupBy gb = this.sorter != null ? this.source.group(this.partitioner).sort(this.sorter) : this.source.group(this.partitioner);
        int h = gb.getSource().height();
        int aggW = aggregators.length;
        Object[][] data = new Object[aggW][h];
        for (int i = 0; i < aggW; ++i) {
            data[i] = new Object[h];
        }
        for (Object key : gb.getGroupKeys()) {
            Series<?>[] gAggs = WindowColumnEvaluator.of(gb.getGroup(key), this.resolveRange()).eval(aggregators);
            IntSeries gIndex = gb.getGroupIndex(key);
            int ih = gIndex.size();
            for (int i = 0; i < aggW; ++i) {
                Series<?> gAgg = gAggs[i];
                for (int j = 0; j < ih; ++j) {
                    data[i][gIndex.getInt((int)j)] = gAgg.get(j);
                }
            }
        }
        Series[] columns = new Series[aggW];
        for (int i = 0; i < aggW; ++i) {
            columns[i] = Series.of(data[i]);
        }
        return columns;
    }

    private Series<?>[] selectUnPartitioned(Exp<?> ... aggregators) {
        DataFrame df = this.sorter != null ? this.source.rows(DataFrameSorter.sort(this.sorter, this.source.height())).select() : this.source;
        return WindowColumnEvaluator.of(df, this.resolveRange()).eval(aggregators);
    }

    private WindowRange resolveRange() {
        return this.range != null ? this.range : WindowRange.all;
    }

    private IntSeries rankPartitioned() {
        return this.sorter != null ? this.source.group(this.partitioner).sort(this.sorter).rank() : Ranker.sameRank(this.source.height());
    }

    private IntSeries rankUnPartitioned() {
        return this.sorter != null ? new Ranker(this.sorter).rank(this.source) : Ranker.sameRank(this.source.height());
    }

    private IntSeries denseRankPartitioned() {
        return this.sorter != null ? this.source.group(this.partitioner).sort(this.sorter).denseRank() : Ranker.sameRank(this.source.height());
    }

    private IntSeries denseRankUnPartitioned() {
        return this.sorter != null ? new DenseRanker(this.sorter).rank(this.source) : Ranker.sameRank(this.source.height());
    }

    private IntSeries rowNumberPartitioned() {
        GroupBy gb = this.sorter != null ? this.source.group(this.partitioner).sort(this.sorter) : this.source.group(this.partitioner);
        Set<Object> groupKeys = gb.getGroupKeys();
        int len = groupKeys.size();
        IntSeries[] groupIndices = new IntSeries[len];
        int i = 0;
        for (Object key : groupKeys) {
            groupIndices[i++] = gb.getGroupIndex(key);
        }
        return RowNumberer.rowNumber(this.source, groupIndices);
    }

    private IntSeries rowNumberUnPartitioned() {
        return this.sorter != null ? RowNumberer.rowNumber(this.source, this.sorter) : RowNumberer.sequence(this.source.height());
    }
}

