/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.window;

import org.dflib.DataFrame;
import org.dflib.IntSeries;
import org.dflib.Series;
import org.dflib.concat.SeriesConcat;
import org.dflib.series.IntSequenceSeries;
import org.dflib.sort.DataFrameSorter;
import org.dflib.sort.IntComparator;

public class RowNumberer {
    static final int START_NUMBER = 1;

    public static IntSeries sequence(int size) {
        return new IntSequenceSeries(1, 1 + size);
    }

    public static void fillSequence(int[] buffer, int offset, int size) {
        for (int i = 0; i < size; ++i) {
            buffer[i + offset] = 1 + i;
        }
    }

    public static IntSeries rowNumber(DataFrame dataFrame, IntComparator sorter) {
        IntSeries rowPositions = DataFrameSorter.sort(sorter, dataFrame.height()).sortIndexInt();
        return (IntSeries)RowNumberer.sequence(dataFrame.height()).select(rowPositions);
    }

    public static IntSeries rowNumber(DataFrame dataFrame, IntSeries[] partitionsIndex) {
        int[] rowNumbers = new int[dataFrame.height()];
        int offset = 0;
        for (IntSeries s : partitionsIndex) {
            int len = s.size();
            RowNumberer.fillSequence(rowNumbers, offset, len);
            offset += len;
        }
        IntSeries groupsIndexGlued = SeriesConcat.intConcat(partitionsIndex);
        return (IntSeries)Series.ofInt(rowNumbers).select(groupsIndexGlued.sortIndexInt());
    }
}

