/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.sort;

import java.util.Arrays;
import java.util.Comparator;
import org.dflib.IntSeries;
import org.dflib.Series;
import org.dflib.Sorter;
import org.dflib.series.ArraySeries;
import org.dflib.series.IntArraySeries;
import org.dflib.sort.Comparators;
import org.dflib.sort.IntComparator;
import org.dflib.sort.IntTimSort;

public class SeriesSorter<T> {
    private final Series<T> s;

    public SeriesSorter(Series<T> s) {
        this.s = s;
    }

    public static int[] rowNumberSequence(int h) {
        int[] rn = new int[h];
        for (int i = 0; i < h; ++i) {
            rn[i] = i;
        }
        return rn;
    }

    public IntSeries sortIndex(IntComparator comparator) {
        int[] mutableIndex = SeriesSorter.rowNumberSequence(this.s.size());
        IntTimSort.sort(mutableIndex, comparator);
        return new IntArraySeries(mutableIndex);
    }

    public IntSeries sortIndex(Comparator<? super T> comparator) {
        return this.sortIndex(Comparators.of(this.s, comparator));
    }

    public IntSeries sortIndex(Sorter ... sorters) {
        return this.sortIndex(Comparators.of(this.s, sorters));
    }

    public Series<T> sort(Sorter ... sorters) {
        return sorters.length == 0 ? this.s : this.s.select(this.sortIndex(sorters));
    }

    public Series<T> sort(Comparator<? super T> comparator) {
        int size = this.s.size();
        Object[] sorted = new Object[size];
        this.s.copyTo(sorted, 0, 0, size);
        Arrays.sort(sorted, comparator);
        return new ArraySeries<Object>(sorted);
    }
}

