/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.sort;

import java.util.LinkedHashMap;
import java.util.Objects;
import org.dflib.DataFrame;
import org.dflib.GroupBy;
import org.dflib.IntSeries;
import org.dflib.Sorter;
import org.dflib.sort.Comparators;
import org.dflib.sort.DataFrameSorter;
import org.dflib.sort.IntComparator;

public class GroupBySorter {
    private final GroupBy groupBy;

    public GroupBySorter(GroupBy groupBy) {
        this.groupBy = groupBy;
    }

    public GroupBy sort(String column, boolean ascending) {
        return this.sort(Comparators.of(this.groupBy.getSource().getColumn(column), ascending));
    }

    public GroupBy sort(int column, boolean ascending) {
        return this.sort(Comparators.of(this.groupBy.getSource().getColumn(column), ascending));
    }

    public GroupBy sort(String[] columns, boolean[] ascending) {
        return this.sort(Comparators.of(this.groupBy.getSource(), columns, ascending));
    }

    public GroupBy sort(int[] columns, boolean[] ascending) {
        return this.sort(Comparators.of(this.groupBy.getSource(), columns, ascending));
    }

    public GroupBy sort(Sorter ... sorters) {
        return sorters.length == 0 ? this.groupBy : this.sort(Comparators.of(this.groupBy.getSource(), sorters));
    }

    public GroupBy sort(IntComparator sorter) {
        Objects.requireNonNull(sorter, "Null 'sorter'");
        DataFrame ungrouped = this.groupBy.getSource();
        LinkedHashMap<Object, IntSeries> sorted = new LinkedHashMap<Object, IntSeries>((int)((double)this.groupBy.size() / 0.75));
        for (Object groupKey : this.groupBy.getGroupKeys()) {
            IntSeries groupIndex = this.groupBy.getGroupIndex(groupKey);
            IntSeries sortedGroup = DataFrameSorter.sort(sorter, groupIndex);
            sorted.put(groupKey, sortedGroup);
        }
        return new GroupBy(ungrouped, sorted, sorter);
    }
}

