/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.slice;

import org.dflib.BooleanSeries;
import org.dflib.Series;
import org.dflib.range.Range;
import org.dflib.series.IntSequenceSeries;
import org.dflib.slice.ColumnExpander;
import org.dflib.slice.RowSetMerger;

class RangeRowSetMerger
extends RowSetMerger {
    private final int fromInclusive;
    private final int toExclusive;
    private final int srcLen;
    private volatile RowSetMerger delegate;

    RangeRowSetMerger(int srcLen, int fromInclusive, int toExclusive) {
        Range.checkRange(fromInclusive, toExclusive - fromInclusive, srcLen);
        this.fromInclusive = fromInclusive;
        this.toExclusive = toExclusive;
        this.srcLen = srcLen;
    }

    @Override
    public <T> Series<T> merge(Series<T> srcColumn, Series<T> rsColumn) {
        int rangeLen = this.toExclusive - this.fromInclusive;
        if (rangeLen != rsColumn.size()) {
            throw new IllegalArgumentException("Unexpected row set length: " + rsColumn.size() + " (expected " + rangeLen + ")");
        }
        if (rangeLen == 0) {
            return srcColumn;
        }
        Object[] values = new Object[this.srcLen];
        if (this.fromInclusive > 0) {
            srcColumn.copyTo(values, 0, 0, this.fromInclusive);
        }
        rsColumn.copyTo(values, 0, this.fromInclusive, rangeLen);
        if (this.toExclusive < this.srcLen) {
            srcColumn.copyTo(values, this.toExclusive, this.toExclusive, this.srcLen - this.toExclusive);
        }
        return Series.of(values);
    }

    @Override
    public RowSetMerger removeUnmatchedRows(BooleanSeries rsCondition) {
        return this.delegate().removeUnmatchedRows(rsCondition);
    }

    @Override
    public RowSetMerger expandCols(ColumnExpander expander) {
        return this.delegate().expandCols(expander);
    }

    private RowSetMerger delegate() {
        if (this.delegate == null) {
            this.delegate = RowSetMerger.of(this.srcLen, new IntSequenceSeries(this.fromInclusive, this.toExclusive));
        }
        return this.delegate;
    }
}

