/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.slice;

import org.dflib.BooleanSeries;
import org.dflib.IntSeries;
import org.dflib.Series;
import org.dflib.slice.ColumnExpander;
import org.dflib.slice.RowSetMerger;

class DefaultRowSetMerger
extends RowSetMerger {
    private final int[] mergeIndex;

    DefaultRowSetMerger(int[] mergeIndex) {
        this.mergeIndex = mergeIndex;
    }

    @Override
    public <T> Series<T> merge(Series<T> srcColumn, Series<T> rsColumn) {
        int h = this.mergeIndex.length;
        Object[] values = new Object[h];
        for (int i = 0; i < h; ++i) {
            int si = this.mergeIndex[i];
            values[i] = si < 0 ? rsColumn.get(-1 - si) : srcColumn.get(si);
        }
        return Series.of(values);
    }

    @Override
    public RowSetMerger removeUnmatchedRows(BooleanSeries rsCondition) {
        int ch = this.mergeIndex.length;
        int nh = ch - rsCondition.size() + rsCondition.countTrue();
        if (ch == nh) {
            return this;
        }
        int[] shrunkIndex = new int[nh];
        int si = 0;
        int rsi = 0;
        for (int i = 0; i < ch; ++i) {
            int mv = this.mergeIndex[i];
            if (mv < 0) {
                if (!rsCondition.getBool(rsi++)) continue;
                shrunkIndex[si++] = mv;
                continue;
            }
            shrunkIndex[si++] = mv;
        }
        return new DefaultRowSetMerger(shrunkIndex);
    }

    @Override
    public RowSetMerger expandCols(ColumnExpander expander) {
        IntSeries rsStretchCounts = expander.getStretchCounts();
        int rsLen = expander.getExpanded().size();
        int ch = this.mergeIndex.length;
        int nn = this.mergeIndex.length - rsStretchCounts.size() + rsLen;
        int[] explodeIndex = new int[nn];
        int si = 0;
        int rsi = 0;
        int et = 0;
        for (int i = 0; i < ch; ++i) {
            int mv = this.mergeIndex[i];
            if (mv < 0) {
                int explodeBy = rsStretchCounts.getInt(rsi++);
                for (int j = 0; j < explodeBy; ++j) {
                    explodeIndex[si++] = mv - et - j;
                }
                et += explodeBy - 1;
                continue;
            }
            explodeIndex[si++] = mv;
        }
        return new DefaultRowSetMerger(explodeIndex);
    }
}

