/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.slice;

import org.dflib.BooleanSeries;
import org.dflib.DataFrame;
import org.dflib.IntSeries;
import org.dflib.RowSet;
import org.dflib.Series;
import org.dflib.slice.BaseRowSet;
import org.dflib.slice.RowSetMerger;

public class ConditionalRowSet
extends BaseRowSet {
    private final BooleanSeries conditionalIndex;

    public ConditionalRowSet(DataFrame source, Series<?>[] sourceColumns, BooleanSeries conditionalIndex) {
        this(source, sourceColumns, -1, conditionalIndex);
    }

    protected ConditionalRowSet(DataFrame source, Series<?>[] sourceColumns, int expansionColumn, BooleanSeries conditionalIndex) {
        super(source, sourceColumns, expansionColumn);
        this.conditionalIndex = conditionalIndex;
    }

    @Override
    public RowSet expand(int columnPos) {
        return this.expansionColumn != columnPos ? new ConditionalRowSet(this.source, this.sourceColumns, columnPos, this.conditionalIndex) : this;
    }

    @Override
    public DataFrame drop() {
        return new ConditionalRowSet(this.source, this.sourceColumns, this.conditionalIndex.not()).select();
    }

    @Override
    public BooleanSeries locate() {
        return this.conditionalIndex;
    }

    @Override
    public IntSeries index() {
        return this.conditionalIndex.indexTrue();
    }

    @Override
    protected int size() {
        return this.conditionalIndex.countTrue();
    }

    @Override
    protected <T> Series<T> doSelect(Series<T> sourceColumn) {
        return sourceColumn.select(this.conditionalIndex);
    }

    @Override
    protected RowSetMerger merger() {
        return RowSetMerger.of(this.conditionalIndex);
    }
}

