/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.set;

import java.util.HashSet;
import java.util.Set;
import org.dflib.BooleanSeries;
import org.dflib.DoubleSeries;
import org.dflib.FloatSeries;
import org.dflib.IntSeries;
import org.dflib.LongSeries;
import org.dflib.Series;

public class Intersect {
    public static <T> Series<T> intersect(Series<T> s1, Series<? extends T> s2) {
        int l1 = s1.size();
        if (l1 == 0) {
            return s1;
        }
        if (s2.size() == 0) {
            return s2;
        }
        Set s2Vals = s2.toSet();
        return s1.select(v -> s2Vals.contains(v));
    }

    public static BooleanSeries intersectBool(BooleanSeries s1, Series<? extends Boolean> s2) {
        int l1 = s1.size();
        if (l1 == 0) {
            return s1;
        }
        if (s2.size() == 0) {
            return Series.ofBool(new boolean[0]);
        }
        HashSet<Boolean> s2Vals = new HashSet<Boolean>(3);
        for (Boolean bl : s2) {
            if (bl == null) continue;
            s2Vals.add(bl);
            if (s2Vals.size() != 2) continue;
            break;
        }
        switch (s2Vals.size()) {
            case 0: {
                return Series.ofBool(new boolean[0]);
            }
            case 1: {
                Boolean b = (Boolean)s2Vals.iterator().next();
                return s1.select(v -> v == b);
            }
        }
        return s1;
    }

    public static IntSeries intersectInt(IntSeries s1, Series<? extends Integer> s2) {
        int l1 = s1.size();
        if (l1 == 0) {
            return s1;
        }
        if (s2.size() == 0) {
            return Series.ofInt(new int[0]);
        }
        Set<? extends Integer> s2Vals = s2.toSet();
        return s1.selectInt(v -> s2Vals.contains(v));
    }

    public static LongSeries intersectLong(LongSeries s1, Series<? extends Long> s2) {
        int l1 = s1.size();
        if (l1 == 0) {
            return s1;
        }
        if (s2.size() == 0) {
            return Series.ofLong(new long[0]);
        }
        Set<? extends Long> s2Vals = s2.toSet();
        return s1.selectLong(v -> s2Vals.contains(v));
    }

    public static FloatSeries intersectFloat(FloatSeries s1, Series<? extends Float> s2) {
        int l1 = s1.size();
        if (l1 == 0) {
            return s1;
        }
        if (s2.size() == 0) {
            return Series.ofFloat(new float[0]);
        }
        Set<? extends Float> s2Vals = s2.toSet();
        return s1.selectFloat(v -> s2Vals.contains(Float.valueOf(v)));
    }

    public static DoubleSeries intersectDouble(DoubleSeries s1, Series<? extends Double> s2) {
        int l1 = s1.size();
        if (l1 == 0) {
            return s1;
        }
        if (s2.size() == 0) {
            return Series.ofDouble(new double[0]);
        }
        Set<? extends Double> s2Vals = s2.toSet();
        return s1.selectDouble(v -> s2Vals.contains(v));
    }
}

