/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import java.util.Arrays;
import java.util.Objects;
import org.dflib.Series;
import org.dflib.series.ArraySeries;
import org.dflib.series.OffsetSeries;

public class OffsetLeadSeries<T>
extends OffsetSeries<T> {
    private final int offset;

    public OffsetLeadSeries(Series<T> delegate, int offset, T filler) {
        super(delegate, filler);
        if (offset <= 0) {
            throw new IllegalArgumentException("Expected positive offset: " + offset);
        }
        this.offset = offset;
    }

    @Override
    public Series<T> shift(int offset, T filler) {
        return offset > 0 && Objects.equals(filler, this.filler) ? new OffsetLeadSeries<T>(this.delegate, this.offset + offset, filler) : super.shift(offset, filler);
    }

    @Override
    public T get(int index) {
        int size = this.size();
        if (index >= size || index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (T)(index < this.offset ? this.filler : this.delegate.get(index - this.offset));
    }

    @Override
    public void copyTo(Object[] to, int fromOffset, int toOffset, int len) {
        int off2;
        int size = this.size();
        if (fromOffset + len > size) {
            throw new ArrayIndexOutOfBoundsException(fromOffset + len);
        }
        int len1 = Math.max(0, Math.min(this.offset - fromOffset, len));
        int len2 = len - len1;
        int n = off2 = fromOffset < this.offset ? 0 : fromOffset - this.offset;
        if (len1 > 0) {
            Arrays.fill(to, toOffset, toOffset + len1, this.filler);
        }
        if (len2 > 0) {
            this.delegate.copyTo(to, off2, toOffset + len1, len2);
        }
    }

    @Override
    public Series<T> materialize() {
        int size = this.size();
        Object[] buffer = new Object[size];
        if (this.filler != null) {
            Arrays.fill(buffer, 0, this.offset, this.filler);
        }
        this.delegate.copyTo(buffer, 0, this.offset, size - this.offset);
        return new ArraySeries<Object>(buffer);
    }
}

