/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import java.util.Arrays;
import org.dflib.LongSeries;
import org.dflib.Series;
import org.dflib.agg.PrimitiveSeriesSum;
import org.dflib.range.Range;
import org.dflib.series.LongArraySeries;
import org.dflib.series.LongBaseSeries;

public class LongSingleValueSeries
extends LongBaseSeries {
    private final long value;
    private final Long boxedValue;
    private final int size;

    public LongSingleValueSeries(long value, int size) {
        this.value = value;
        this.size = size;
        this.boxedValue = value;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Long get(int index) {
        return this.boxedValue;
    }

    @Override
    public long getLong(int index) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.value;
    }

    @Override
    public void copyToLong(long[] to, int fromOffset, int toOffset, int len) {
        Arrays.fill(to, toOffset, toOffset + len, this.value);
    }

    @Override
    public LongSeries diff(Series<? extends Long> other) {
        if (this.size == 0 || other.size() == 0) {
            return this;
        }
        for (Long l : other) {
            if (l == null || l != this.value) continue;
            return Series.ofLong(new long[0]);
        }
        return this;
    }

    @Override
    public LongSeries intersect(Series<? extends Long> other) {
        if (this.size == 0) {
            return this;
        }
        if (other.size() == 0) {
            return Series.ofLong(new long[0]);
        }
        for (Long l : other) {
            if (l == null || l != this.value) continue;
            return this;
        }
        return Series.ofLong(new long[0]);
    }

    @Override
    public LongSeries materialize() {
        return this;
    }

    @Override
    public LongSeries rangeLong(int fromInclusive, int toExclusive) {
        if (fromInclusive == toExclusive) {
            return new LongArraySeries(new long[0]);
        }
        if (fromInclusive == 0 && toExclusive == this.size) {
            return this;
        }
        Range.checkRange(fromInclusive, toExclusive - fromInclusive, this.size);
        return new LongSingleValueSeries(this.value, toExclusive - fromInclusive);
    }

    @Override
    public LongSeries cumSum() {
        long[] cumSum = PrimitiveSeriesSum.cumSumOfValue(this.value, this.size);
        return new LongArraySeries(cumSum);
    }

    @Override
    public long max() {
        return this.value;
    }

    @Override
    public long min() {
        return this.value;
    }

    @Override
    public long sum() {
        return this.value * (long)this.size;
    }

    @Override
    public double avg() {
        return this.value;
    }

    @Override
    public double median() {
        return this.value;
    }

    @Override
    public double quantile(double q) {
        return this.value;
    }
}

