/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.dflib.BooleanSeries;
import org.dflib.Condition;
import org.dflib.DataFrame;
import org.dflib.Index;
import org.dflib.IntSeries;
import org.dflib.LongSeries;
import org.dflib.Series;
import org.dflib.SeriesGroupBy;
import org.dflib.Sorter;
import org.dflib.ValueMapper;
import org.dflib.ValueToRowMapper;
import org.dflib.builder.BoolBuilder;
import org.dflib.builder.IntAccum;
import org.dflib.builder.LongAccum;
import org.dflib.builder.ObjectAccum;
import org.dflib.builder.UniqueLongAccum;
import org.dflib.concat.SeriesConcat;
import org.dflib.groupby.SeriesGrouper;
import org.dflib.map.Mapper;
import org.dflib.sample.Sampler;
import org.dflib.series.ArraySeries;
import org.dflib.series.FalseSeries;
import org.dflib.series.LongArraySeries;
import org.dflib.series.ToString;
import org.dflib.series.TrueSeries;
import org.dflib.series.ValueCounts;
import org.dflib.sort.SeriesSorter;

public abstract class LongBaseSeries
implements LongSeries {
    @Override
    public <S> Series<S> castAs(Class<S> type) {
        if (!type.isAssignableFrom(Long.class) && !type.equals(Long.TYPE)) {
            throw new ClassCastException("LongSeries can not be cast to " + String.valueOf(type));
        }
        return this;
    }

    @Override
    public DataFrame map(Index resultColumns, ValueToRowMapper<Long> mapper) {
        return Mapper.map(this, resultColumns, mapper);
    }

    @Override
    public Series<Long> selectRange(int fromInclusive, int toExclusive) {
        return this.rangeLong(fromInclusive, toExclusive);
    }

    @Override
    public LongSeries select(Predicate<Long> p) {
        return this.selectLong(p::test);
    }

    @Override
    public LongSeries select(Condition condition) {
        return this.select((BooleanSeries)condition.eval((Series)this));
    }

    @Override
    public LongSeries select(BooleanSeries positions) {
        int i;
        int len = this.size();
        if (len != positions.size()) {
            throw new IllegalArgumentException("Positions size " + positions.size() + " is not the same as this size " + len);
        }
        for (i = 0; i < len && !positions.getBool(i); ++i) {
        }
        if (i == len) {
            return Series.ofLong(new long[0]);
        }
        LongAccum filtered = new LongAccum(len - i);
        filtered.pushLong(this.getLong(i));
        ++i;
        while (i < len) {
            if (positions.getBool(i)) {
                filtered.pushLong(this.getLong(i));
            }
            ++i;
        }
        return filtered.toSeries();
    }

    @Override
    public LongSeries selectLong(LongPredicate p) {
        int i;
        int len = this.size();
        for (i = 0; i < len && !p.test(this.getLong(i)); ++i) {
        }
        if (i == len) {
            return Series.ofLong(new long[0]);
        }
        LongAccum filtered = new LongAccum(len - i);
        filtered.pushLong(this.getLong(i));
        ++i;
        while (i < len) {
            long v = this.getLong(i);
            if (p.test(v)) {
                filtered.pushLong(v);
            }
            ++i;
        }
        return filtered.toSeries();
    }

    @Override
    public LongSeries sort(Sorter ... sorters) {
        return this.selectAsLongSeries(new SeriesSorter<Long>(this).sortIndex(sorters));
    }

    @Override
    public LongSeries sort(Comparator<? super Long> comparator) {
        return this.selectAsLongSeries(new SeriesSorter<Long>(this).sortIndex(comparator));
    }

    @Override
    public LongSeries sortLong() {
        int size = this.size();
        long[] sorted = new long[size];
        this.copyToLong(sorted, 0, 0, size);
        Arrays.sort(sorted);
        return new LongArraySeries(sorted);
    }

    private LongSeries selectAsLongSeries(IntSeries positions) {
        int h = positions.size();
        long[] data = new long[h];
        for (int i = 0; i < h; ++i) {
            int index = positions.getInt(i);
            data[i] = this.getLong(index);
        }
        return new LongArraySeries(data);
    }

    private Series<Long> selectAsObjectSeries(IntSeries positions) {
        int h = positions.size();
        Long[] data = new Long[h];
        for (int i = 0; i < h; ++i) {
            int index = positions.getInt(i);
            data[i] = index < 0 ? null : Long.valueOf(this.getLong(index));
        }
        return new ArraySeries<Long>(data);
    }

    @Override
    public LongSeries concatLong(LongSeries ... other) {
        int size;
        if (other.length == 0) {
            return this;
        }
        int h = size = this.size();
        for (LongSeries s : other) {
            h += s.size();
        }
        long[] data = new long[h];
        this.copyToLong(data, 0, 0, size);
        int offset = size;
        for (LongSeries s : other) {
            int len = s.size();
            s.copyToLong(data, 0, offset, len);
            offset += len;
        }
        return new LongArraySeries(data);
    }

    @Override
    public Series<Long> fillNulls(Long value) {
        return this;
    }

    @Override
    public Series<Long> fillNullsFromSeries(Series<? extends Long> values) {
        return this;
    }

    @Override
    public Series<Long> fillNullsBackwards() {
        return this;
    }

    @Override
    public Series<Long> fillNullsForward() {
        return this;
    }

    @Override
    @SafeVarargs
    public final Series<Long> concat(Series<? extends Long> ... other) {
        if (other.length == 0) {
            return this;
        }
        Series[] combined = new Series[other.length + 1];
        combined[0] = this;
        System.arraycopy(other, 0, combined, 1, other.length);
        return SeriesConcat.concat(combined);
    }

    @Override
    public void copyTo(Object[] to, int fromOffset, int toOffset, int len) {
        for (int i = 0; i < len; ++i) {
            to[toOffset + i] = this.getLong(fromOffset + i);
        }
    }

    @Override
    public IntSeries indexLong(LongPredicate predicate) {
        int len = this.size();
        IntAccum index = new IntAccum(len);
        for (int i = 0; i < len; ++i) {
            if (!predicate.test(this.getLong(i))) continue;
            index.pushInt(i);
        }
        return index.toSeries();
    }

    @Override
    public IntSeries index(Predicate<Long> predicate) {
        int len = this.size();
        IntAccum index = new IntAccum(len);
        for (int i = 0; i < len; ++i) {
            if (!predicate.test(this.get(i))) continue;
            index.pushInt(i);
        }
        return index.toSeries();
    }

    @Override
    public BooleanSeries locateLong(LongPredicate predicate) {
        return BoolBuilder.buildSeries(i -> predicate.test(this.getLong(i)), this.size());
    }

    @Override
    public Series<Long> replace(Map<Long, Long> oldToNewValues) {
        int len = this.size();
        long[] replaced = new long[len];
        for (int i = 0; i < len; ++i) {
            Long val = this.getLong(i);
            Long newVal = oldToNewValues.getOrDefault(val, val);
            if (newVal == null) {
                return this.replaceAsObjects(oldToNewValues);
            }
            replaced[i] = newVal;
        }
        return Series.ofLong(replaced);
    }

    private Series<Long> replaceAsObjects(Map<Long, Long> oldToNewValues) {
        int len = this.size();
        Long[] replaced = new Long[len];
        for (int i = 0; i < len; ++i) {
            Long val = this.getLong(i);
            replaced[i] = oldToNewValues.getOrDefault(val, val);
        }
        return Series.of(replaced);
    }

    @Override
    public Series<Long> replace(IntSeries positions, Series<Long> with) {
        int rs = positions.size();
        if (rs != with.size()) {
            throw new IllegalArgumentException("Positions size " + rs + " is not the same replacement Series size " + with.size());
        }
        if (rs == 0) {
            return this;
        }
        int s = this.size();
        if (with instanceof LongSeries) {
            LongSeries withLong = (LongSeries)with;
            LongAccum values = new LongAccum(s);
            values.fill(this, 0, 0, s);
            for (int i = 0; i < rs; ++i) {
                values.replace(positions.getInt(i), withLong.getLong(i));
            }
            return values.toSeries();
        }
        ObjectAccum<Long> values = new ObjectAccum<Long>(s);
        values.fill(this, 0, 0, s);
        for (int i = 0; i < rs; ++i) {
            values.replace(positions.getInt(i), with.get(i));
        }
        return values.toSeries();
    }

    @Override
    public Series<Long> replace(BooleanSeries condition, Long with) {
        return with != null ? this.replaceLong(condition, (long)with) : this.nullify(condition);
    }

    @Override
    public Series<Long> replaceExcept(BooleanSeries condition, Long with) {
        return with != null ? this.replaceNoMatchLong(condition, with) : this.nullifyNoMatch(condition);
    }

    private LongSeries replaceLong(BooleanSeries condition, long with) {
        int i;
        int len = this.size();
        int r = Math.min(len, condition.size());
        long[] data = new long[len];
        for (i = 0; i < r; ++i) {
            data[i] = condition.getBool(i) ? with : this.getLong(i);
        }
        for (i = r; i < len; ++i) {
            data[i] = this.getLong(i);
        }
        return new LongArraySeries(data);
    }

    private LongSeries replaceNoMatchLong(BooleanSeries condition, long with) {
        int len = this.size();
        int r = Math.min(len, condition.size());
        long[] data = new long[len];
        for (int i = 0; i < r; ++i) {
            data[i] = condition.getBool(i) ? this.getLong(i) : with;
        }
        if (len > r) {
            Arrays.fill(data, r, len, with);
        }
        return new LongArraySeries(data);
    }

    private Series<Long> nullify(BooleanSeries condition) {
        int i;
        int len = this.size();
        int r = Math.min(len, condition.size());
        Long[] data = new Long[len];
        for (i = 0; i < r; ++i) {
            data[i] = condition.getBool(i) ? null : Long.valueOf(this.getLong(i));
        }
        for (i = r; i < len; ++i) {
            data[i] = this.getLong(i);
        }
        return new ArraySeries<Long>(data);
    }

    private Series<Long> nullifyNoMatch(BooleanSeries condition) {
        int len = this.size();
        int r = Math.min(len, condition.size());
        Object[] data = new Long[len];
        for (int i = 0; i < r; ++i) {
            data[i] = condition.getBool(i) ? Long.valueOf(this.getLong(i)) : null;
        }
        if (len > r) {
            Arrays.fill(data, r, len, null);
        }
        return new ArraySeries<Long>(data);
    }

    @Override
    public BooleanSeries in(Object ... values) {
        int len = this.size();
        if (values == null || values.length == 0) {
            return new FalseSeries(len);
        }
        HashSet<Object> set = new HashSet<Object>();
        for (Object o : values) {
            if (!(o instanceof Long)) continue;
            set.add(o);
        }
        if (set.isEmpty()) {
            return new FalseSeries(len);
        }
        return BoolBuilder.buildSeries(i -> set.contains(this.get(i)), len);
    }

    @Override
    public BooleanSeries notIn(Object ... values) {
        int len = this.size();
        if (values == null || values.length == 0) {
            return new TrueSeries(len);
        }
        HashSet<Object> set = new HashSet<Object>();
        for (Object o : values) {
            if (!(o instanceof Long)) continue;
            set.add(o);
        }
        if (set.isEmpty()) {
            return new TrueSeries(len);
        }
        return BoolBuilder.buildSeries(i -> !set.contains(this.get(i)), len);
    }

    @Override
    public LongSeries unique() {
        int size = this.size();
        if (size < 2) {
            return this;
        }
        UniqueLongAccum unique = new UniqueLongAccum();
        for (int i = 0; i < size; ++i) {
            unique.push(this.get(i));
        }
        return unique.size() < this.size() ? unique.toSeries() : this;
    }

    @Override
    public DataFrame valueCounts() {
        return ValueCounts.valueCountsNoNulls(this);
    }

    @Override
    public SeriesGroupBy<Long> group() {
        return this.group((Long l) -> l);
    }

    @Override
    public SeriesGroupBy<Long> group(ValueMapper<Long, ?> by) {
        return new SeriesGrouper<Long>(by).group(this);
    }

    @Override
    public LongSeries sample(int size) {
        return this.selectAsLongSeries(Sampler.sampleIndex(size, this.size()));
    }

    @Override
    public LongSeries sample(int size, Random random) {
        return this.selectAsLongSeries(Sampler.sampleIndex(size, this.size(), random));
    }

    public String toString() {
        return ToString.toString(this);
    }
}

