/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import org.dflib.LongSeries;
import org.dflib.agg.Percentiles;
import org.dflib.agg.PrimitiveSeriesAvg;
import org.dflib.agg.PrimitiveSeriesMinMax;
import org.dflib.agg.PrimitiveSeriesSum;
import org.dflib.range.Range;
import org.dflib.series.LongArraySeries;
import org.dflib.series.LongBaseSeries;

public class LongArrayRangeSeries
extends LongBaseSeries {
    private final long[] data;
    private final int offset;
    private final int size;

    public LongArrayRangeSeries(long[] data, int offset, int size) {
        Range.checkRange(offset, size, data.length);
        this.data = data;
        this.offset = offset;
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public LongSeries add(LongSeries s) {
        if (!(s instanceof LongArrayRangeSeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        LongArrayRangeSeries as = (LongArrayRangeSeries)s;
        long[] l = this.data;
        long[] r = as.data;
        int lo = this.offset;
        int ro = as.offset;
        long[] data = new long[len];
        if (lo > 0 || ro > 0) {
            for (int i = 0; i < len; ++i) {
                data[i] = l[lo + i] + r[ro + i];
            }
        } else {
            for (int i = 0; i < len; ++i) {
                data[i] = l[i] + r[i];
            }
        }
        return new LongArraySeries(data);
    }

    @Override
    public LongSeries sub(LongSeries s) {
        if (!(s instanceof LongArrayRangeSeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        LongArrayRangeSeries as = (LongArrayRangeSeries)s;
        long[] l = this.data;
        long[] r = as.data;
        int lo = this.offset;
        int ro = as.offset;
        long[] data = new long[len];
        if (lo > 0 || ro > 0) {
            for (int i = 0; i < len; ++i) {
                data[i] = l[lo + i] - r[ro + i];
            }
        } else {
            for (int i = 0; i < len; ++i) {
                data[i] = l[i] - r[i];
            }
        }
        return new LongArraySeries(data);
    }

    @Override
    public LongSeries mul(LongSeries s) {
        if (!(s instanceof LongArrayRangeSeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        LongArrayRangeSeries as = (LongArrayRangeSeries)s;
        long[] l = this.data;
        long[] r = as.data;
        int lo = this.offset;
        int ro = as.offset;
        long[] data = new long[len];
        if (lo > 0 || ro > 0) {
            for (int i = 0; i < len; ++i) {
                data[i] = l[lo + i] * r[ro + i];
            }
        } else {
            for (int i = 0; i < len; ++i) {
                data[i] = l[i] * r[i];
            }
        }
        return new LongArraySeries(data);
    }

    @Override
    public LongSeries div(LongSeries s) {
        if (!(s instanceof LongArrayRangeSeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        LongArrayRangeSeries as = (LongArrayRangeSeries)s;
        long[] l = this.data;
        long[] r = as.data;
        int lo = this.offset;
        int ro = as.offset;
        long[] data = new long[len];
        if (lo > 0 || ro > 0) {
            for (int i = 0; i < len; ++i) {
                data[i] = l[lo + i] / r[ro + i];
            }
        } else {
            for (int i = 0; i < len; ++i) {
                data[i] = l[i] / r[i];
            }
        }
        return new LongArraySeries(data);
    }

    @Override
    public LongSeries mod(LongSeries s) {
        if (!(s instanceof LongArrayRangeSeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        LongArrayRangeSeries as = (LongArrayRangeSeries)s;
        long[] l = this.data;
        long[] r = as.data;
        int lo = this.offset;
        int ro = as.offset;
        long[] data = new long[len];
        if (lo > 0 || ro > 0) {
            for (int i = 0; i < len; ++i) {
                data[i] = l[lo + i] % r[ro + i];
            }
        } else {
            for (int i = 0; i < len; ++i) {
                data[i] = l[i] % r[i];
            }
        }
        return new LongArraySeries(data);
    }

    @Override
    public long getLong(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.data[this.offset + index];
    }

    @Override
    public void copyToLong(long[] to, int fromOffset, int toOffset, int len) {
        if (fromOffset + len > this.size) {
            throw new ArrayIndexOutOfBoundsException(fromOffset + len);
        }
        System.arraycopy(this.data, this.offset + fromOffset, to, toOffset, len);
    }

    @Override
    public LongSeries rangeLong(int fromInclusive, int toExclusive) {
        return fromInclusive == 0 && toExclusive == this.size() ? this : new LongArrayRangeSeries(this.data, this.offset + fromInclusive, toExclusive - fromInclusive);
    }

    @Override
    public LongSeries materialize() {
        if (this.offset == 0 && this.size == this.data.length) {
            return new LongArraySeries(this.data);
        }
        long[] data = new long[this.size];
        this.copyToLong(data, 0, 0, this.size);
        return new LongArraySeries(data);
    }

    @Override
    public long max() {
        return PrimitiveSeriesMinMax.maxOfArray(this.data, this.offset, this.size);
    }

    @Override
    public long min() {
        return PrimitiveSeriesMinMax.minOfArray(this.data, this.offset, this.size);
    }

    @Override
    public long sum() {
        return PrimitiveSeriesSum.sumOfArray(this.data, this.offset, this.size);
    }

    @Override
    public double avg() {
        return PrimitiveSeriesAvg.avgOfArray(this.data, this.offset, this.size);
    }

    @Override
    public double quantile(double q) {
        return Percentiles.ofArray(this.data, this.offset, this.size, q);
    }

    @Override
    public LongSeries cumSum() {
        long[] cumSum = PrimitiveSeriesSum.cumSumOfArray(this.data, this.offset, this.size);
        return new LongArraySeries(cumSum);
    }
}

