/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import org.dflib.IntSeries;
import org.dflib.LongSeries;
import org.dflib.Series;
import org.dflib.agg.Percentiles;
import org.dflib.agg.PrimitiveSeriesAvg;
import org.dflib.agg.PrimitiveSeriesMinMax;
import org.dflib.agg.PrimitiveSeriesSum;
import org.dflib.range.Range;
import org.dflib.series.IntBaseSeries;
import org.dflib.series.LongArraySeries;

public class IntSequenceSeries
extends IntBaseSeries {
    private final int fromInclusive;
    private final int toExclusive;

    public IntSequenceSeries(int fromInclusive, int toExclusive) {
        if (fromInclusive > toExclusive) {
            throw new IllegalArgumentException("'first' sequence element is larger than 'last': " + fromInclusive + " vs. " + toExclusive);
        }
        this.fromInclusive = fromInclusive;
        this.toExclusive = toExclusive;
    }

    @Override
    public int getInt(int index) {
        int i = this.fromInclusive + index;
        if (i >= this.toExclusive) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return i;
    }

    @Override
    public void copyToInt(int[] to, int fromOffset, int toOffset, int len) {
        if (fromOffset + len > this.toExclusive) {
            throw new ArrayIndexOutOfBoundsException(fromOffset + len);
        }
        for (int i = 0; i < len; ++i) {
            to[toOffset + i] = this.fromInclusive + i;
        }
    }

    @Override
    public IntSeries diff(Series<? extends Integer> other) {
        if (!(other instanceof IntSequenceSeries)) {
            return super.diff((Series)other);
        }
        int otherFirst = ((IntSequenceSeries)other).fromInclusive;
        int otherLastExclusive = ((IntSequenceSeries)other).toExclusive;
        int head = otherFirst - this.fromInclusive;
        int tail = this.toExclusive - otherLastExclusive;
        if (head > 0) {
            if (tail <= 0) {
                return this.head(head);
            }
            int len = head + tail;
            int[] data = new int[len];
            for (int i = 0; i < head; ++i) {
                data[i] = this.fromInclusive + i;
            }
            int tailOffset = this.toExclusive - tail - 1;
            for (int i = head; i < len; ++i) {
                data[i] = tailOffset + i;
            }
            return Series.ofInt(data);
        }
        if (tail > 0) {
            return this.tail(tail);
        }
        return Series.ofInt(new int[0]);
    }

    @Override
    public IntSeries intersect(Series<? extends Integer> other) {
        if (!(other instanceof IntSequenceSeries)) {
            return super.intersect((Series)other);
        }
        int otherFirst = ((IntSequenceSeries)other).fromInclusive;
        int otherLastExclusive = ((IntSequenceSeries)other).toExclusive;
        int head = otherFirst - this.fromInclusive;
        int tail = this.toExclusive - otherLastExclusive;
        if (head > 0) {
            return tail > 0 ? this.head(-head).tail(-tail) : this.head(-head);
        }
        if (tail > 0) {
            return this.tail(-tail);
        }
        return this;
    }

    @Override
    public IntSeries materialize() {
        return this;
    }

    @Override
    public IntSeries rangeInt(int fromInclusive, int toExclusive) {
        int len = this.size();
        if (fromInclusive == 0 && toExclusive == len) {
            return this;
        }
        int newLen = toExclusive - fromInclusive;
        int newFrom = this.fromInclusive + fromInclusive;
        int newTo = this.fromInclusive + toExclusive;
        Range.checkRange(fromInclusive, newLen, len);
        return new IntSequenceSeries(newFrom, newTo);
    }

    @Override
    public int size() {
        return this.toExclusive - this.fromInclusive;
    }

    @Override
    public int max() {
        return PrimitiveSeriesMinMax.maxOfRange(this.toExclusive);
    }

    @Override
    public int min() {
        return PrimitiveSeriesMinMax.minOfRange(this.fromInclusive);
    }

    @Override
    public long sum() {
        return PrimitiveSeriesSum.sumOfRange(this.fromInclusive, this.toExclusive);
    }

    @Override
    public double avg() {
        return PrimitiveSeriesAvg.avgOfRange(this.fromInclusive, this.toExclusive);
    }

    @Override
    public double quantile(double q) {
        return Percentiles.ofRange(q, this.fromInclusive, this.toExclusive);
    }

    @Override
    public LongSeries cumSum() {
        long[] cumSum = PrimitiveSeriesSum.cumSumOfRange(this.fromInclusive, this.toExclusive);
        return new LongArraySeries(cumSum);
    }
}

