/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import java.util.Objects;
import org.dflib.IntSeries;
import org.dflib.LongSeries;
import org.dflib.Series;
import org.dflib.series.IndexedSeries;
import org.dflib.series.IntArraySeries;
import org.dflib.series.IntBaseSeries;

public class IntIndexedSeries
extends IntBaseSeries {
    protected volatile Raw raw;
    protected volatile IntSeries materialized;

    public static Series<Integer> of(IntSeries source, IntSeries includePositions) {
        int len = includePositions.size();
        for (int i = 0; i < len; ++i) {
            if (includePositions.getInt(i) >= 0) continue;
            return new IndexedSeries<Integer>(source, includePositions);
        }
        return new IntIndexedSeries(source, includePositions);
    }

    public IntIndexedSeries(IntSeries source, IntSeries includePositions) {
        this.raw = new Raw(source, includePositions);
    }

    public boolean isMaterialized() {
        return this.materialized != null;
    }

    @Override
    public int size() {
        Raw raw = this.raw;
        return raw != null ? raw.size() : this.materialized.size();
    }

    @Override
    public int getInt(int index) {
        Raw raw = this.raw;
        return raw != null ? raw.getInt(index) : this.materialized.getInt(index);
    }

    @Override
    public void copyToInt(int[] to, int fromOffset, int toOffset, int len) {
        this.materialize().copyToInt(to, fromOffset, toOffset, len);
    }

    @Override
    public IntSeries rangeInt(int fromInclusive, int toExclusive) {
        Raw raw = this.raw;
        return raw != null ? new IntIndexedSeries(raw.source, raw.includePositions.rangeInt(fromInclusive, toExclusive)) : this.materialized.rangeInt(fromInclusive, toExclusive);
    }

    @Override
    public LongSeries cumSum() {
        return this.materialize().cumSum();
    }

    @Override
    public int max() {
        return this.materialize().max();
    }

    @Override
    public int min() {
        return this.materialize().min();
    }

    @Override
    public long sum() {
        return this.materialize().sum();
    }

    @Override
    public double avg() {
        return this.materialize().avg();
    }

    @Override
    public double quantile(double q) {
        return this.materialize().quantile(q);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntSeries materialize() {
        if (this.materialized == null) {
            IntIndexedSeries intIndexedSeries = this;
            synchronized (intIndexedSeries) {
                if (this.materialized == null) {
                    this.materialized = this.raw.materialize();
                    this.raw = null;
                }
            }
        }
        return this.materialized;
    }

    protected static class Raw {
        final IntSeries source;
        final IntSeries includePositions;

        Raw(IntSeries source, IntSeries includePositions) {
            this.source = Objects.requireNonNull(source);
            this.includePositions = Objects.requireNonNull(includePositions);
        }

        int size() {
            return this.includePositions.size();
        }

        int getInt(int index) {
            return this.source.getInt(this.includePositions.getInt(index));
        }

        IntSeries materialize() {
            int h = this.includePositions.size();
            int[] data = new int[h];
            for (int i = 0; i < h; ++i) {
                data[i] = this.getInt(i);
            }
            return new IntArraySeries(data);
        }
    }
}

