/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import java.util.Objects;
import org.dflib.IntSeries;
import org.dflib.Series;
import org.dflib.series.ArraySeries;
import org.dflib.series.ObjectSeries;

public class IndexedSeries<T>
extends ObjectSeries<T> {
    protected volatile Raw<T> raw;
    protected volatile Series<T> materialized;

    public IndexedSeries(Series<T> source, IntSeries includePositions) {
        super(source.getNominalType());
        this.raw = new Raw<T>(source, includePositions);
    }

    public boolean isMaterialized() {
        return this.materialized != null;
    }

    @Override
    public int size() {
        Raw<T> raw = this.raw;
        return raw != null ? raw.size() : this.materialized.size();
    }

    @Override
    public T get(int index) {
        Raw<T> raw = this.raw;
        return raw != null ? raw.get(index) : this.materialized.get(index);
    }

    @Override
    public void copyTo(Object[] to, int fromOffset, int toOffset, int len) {
        this.materialize().copyTo(to, fromOffset, toOffset, len);
    }

    @Override
    public Series<T> selectRange(int fromInclusive, int toExclusive) {
        Raw<T> raw = this.raw;
        return raw != null ? new IndexedSeries(raw.source, raw.includePositions.rangeInt(fromInclusive, toExclusive)) : this.materialized.selectRange(fromInclusive, toExclusive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Series<T> materialize() {
        if (this.materialized == null) {
            IndexedSeries indexedSeries = this;
            synchronized (indexedSeries) {
                if (this.materialized == null) {
                    this.materialized = this.raw.materialize();
                    this.raw = null;
                }
            }
        }
        return this.materialized;
    }

    @Override
    public Series<T> fillNulls(T value) {
        return this.materialize().fillNulls(value);
    }

    @Override
    public Series<T> fillNullsFromSeries(Series<? extends T> values) {
        return this.materialize().fillNullsFromSeries(values);
    }

    @Override
    public Series<T> fillNullsBackwards() {
        return this.materialize().fillNullsBackwards();
    }

    @Override
    public Series<T> fillNullsForward() {
        return this.materialize().fillNullsForward();
    }

    protected static class Raw<T> {
        final Series<T> source;
        final IntSeries includePositions;

        Raw(Series<T> source, IntSeries includePositions) {
            this.source = Objects.requireNonNull(source);
            this.includePositions = Objects.requireNonNull(includePositions);
        }

        int size() {
            return this.includePositions.size();
        }

        T get(int index) {
            int i = this.includePositions.getInt(index);
            return i < 0 ? null : (T)this.source.get(i);
        }

        ArraySeries<T> materialize() {
            int h = this.includePositions.size();
            Object[] data = new Object[h];
            for (int i = 0; i < h; ++i) {
                data[i] = this.get(i);
            }
            return new ArraySeries<Object>(data);
        }
    }
}

