/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import java.util.Arrays;
import org.dflib.DoubleSeries;
import org.dflib.FloatSeries;
import org.dflib.Series;
import org.dflib.agg.PrimitiveSeriesSum;
import org.dflib.range.Range;
import org.dflib.series.DoubleArraySeries;
import org.dflib.series.FloatArraySeries;
import org.dflib.series.FloatBaseSeries;

public class FloatSingleValueSeries
extends FloatBaseSeries {
    private final float value;
    private final Float boxedValue;
    private final int size;

    public FloatSingleValueSeries(float value, int size) {
        this.value = value;
        this.size = size;
        this.boxedValue = Float.valueOf(value);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Float get(int index) {
        return this.boxedValue;
    }

    @Override
    public float getFloat(int index) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.value;
    }

    @Override
    public void copyToFloat(float[] to, int fromOffset, int toOffset, int len) {
        Arrays.fill(to, toOffset, toOffset + len, this.value);
    }

    @Override
    public FloatSeries diff(Series<? extends Float> other) {
        if (this.size == 0 || other.size() == 0) {
            return this;
        }
        for (Float f : other) {
            if (f == null || f.floatValue() != this.value) continue;
            return Series.ofFloat(new float[0]);
        }
        return this;
    }

    @Override
    public FloatSeries intersect(Series<? extends Float> other) {
        if (this.size == 0) {
            return this;
        }
        if (other.size() == 0) {
            return Series.ofFloat(new float[0]);
        }
        for (Float f : other) {
            if (f == null || f.floatValue() != this.value) continue;
            return this;
        }
        return Series.ofFloat(new float[0]);
    }

    @Override
    public FloatSeries materialize() {
        return this;
    }

    @Override
    public FloatSeries rangeFloat(int fromInclusive, int toExclusive) {
        if (fromInclusive == 0 && toExclusive == this.size) {
            return this;
        }
        Range.checkRange(fromInclusive, toExclusive - fromInclusive, this.size);
        if (fromInclusive == toExclusive) {
            return new FloatArraySeries(new float[0]);
        }
        return new FloatSingleValueSeries(this.value, toExclusive - fromInclusive);
    }

    @Override
    public DoubleSeries cumSum() {
        double[] cumSum = PrimitiveSeriesSum.cumSumOfValue(this.value, this.size);
        return new DoubleArraySeries(cumSum);
    }

    @Override
    public float max() {
        return this.value;
    }

    @Override
    public float min() {
        return this.value;
    }

    @Override
    public double sum() {
        return this.value * (float)this.size;
    }

    @Override
    public float avg() {
        return this.value;
    }

    @Override
    public float median() {
        return this.value;
    }

    @Override
    public float quantile(double q) {
        return this.value;
    }
}

