/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import java.util.Objects;
import org.dflib.DoubleSeries;
import org.dflib.FloatSeries;
import org.dflib.IntSeries;
import org.dflib.Series;
import org.dflib.series.FloatArraySeries;
import org.dflib.series.FloatBaseSeries;
import org.dflib.series.IndexedSeries;

public class FloatIndexedSeries
extends FloatBaseSeries {
    protected volatile Raw raw;
    protected volatile FloatSeries materialized;

    public static Series<Float> of(FloatSeries source, IntSeries includePositions) {
        int len = includePositions.size();
        for (int i = 0; i < len; ++i) {
            if (includePositions.getInt(i) >= 0) continue;
            return new IndexedSeries<Float>(source, includePositions);
        }
        return new FloatIndexedSeries(source, includePositions);
    }

    public FloatIndexedSeries(FloatSeries source, IntSeries includePositions) {
        this.raw = new Raw(source, includePositions);
    }

    public boolean isMaterialized() {
        return this.materialized != null;
    }

    @Override
    public int size() {
        Raw raw = this.raw;
        return raw != null ? raw.size() : this.materialized.size();
    }

    @Override
    public float getFloat(int index) {
        Raw raw = this.raw;
        return raw != null ? raw.getFloat(index) : this.materialized.getFloat(index);
    }

    @Override
    public void copyToFloat(float[] to, int fromOffset, int toOffset, int len) {
        this.materialize().copyToFloat(to, fromOffset, toOffset, len);
    }

    @Override
    public FloatSeries rangeFloat(int fromInclusive, int toExclusive) {
        Raw raw = this.raw;
        return raw != null ? new FloatIndexedSeries(raw.source, raw.includePositions.rangeInt(fromInclusive, toExclusive)) : this.materialized.rangeFloat(fromInclusive, toExclusive);
    }

    @Override
    public DoubleSeries cumSum() {
        return this.materialize().cumSum();
    }

    @Override
    public float max() {
        return this.materialize().max();
    }

    @Override
    public float min() {
        return this.materialize().min();
    }

    @Override
    public double sum() {
        return this.materialize().sum();
    }

    @Override
    public float avg() {
        return this.materialize().avg();
    }

    @Override
    public float quantile(double q) {
        return this.materialize().quantile(q);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FloatSeries materialize() {
        if (this.materialized == null) {
            FloatIndexedSeries floatIndexedSeries = this;
            synchronized (floatIndexedSeries) {
                if (this.materialized == null) {
                    this.materialized = this.raw.materialize();
                    this.raw = null;
                }
            }
        }
        return this.materialized;
    }

    protected static class Raw {
        final FloatSeries source;
        final IntSeries includePositions;

        Raw(FloatSeries source, IntSeries includePositions) {
            this.source = Objects.requireNonNull(source);
            this.includePositions = Objects.requireNonNull(includePositions);
        }

        int size() {
            return this.includePositions.size();
        }

        float getFloat(int index) {
            return this.source.getFloat(this.includePositions.getInt(index));
        }

        FloatSeries materialize() {
            int h = this.includePositions.size();
            float[] data = new float[h];
            for (int i = 0; i < h; ++i) {
                data[i] = this.getFloat(i);
            }
            return new FloatArraySeries(data);
        }
    }
}

