/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import org.dflib.BooleanSeries;
import org.dflib.Condition;
import org.dflib.DataFrame;
import org.dflib.FloatSeries;
import org.dflib.Index;
import org.dflib.IntSeries;
import org.dflib.Series;
import org.dflib.SeriesGroupBy;
import org.dflib.Sorter;
import org.dflib.ValueMapper;
import org.dflib.ValueToRowMapper;
import org.dflib.builder.BoolBuilder;
import org.dflib.builder.FloatAccum;
import org.dflib.builder.IntAccum;
import org.dflib.builder.ObjectAccum;
import org.dflib.builder.UniqueFloatAccum;
import org.dflib.concat.SeriesConcat;
import org.dflib.f.FloatPredicate;
import org.dflib.groupby.SeriesGrouper;
import org.dflib.map.Mapper;
import org.dflib.sample.Sampler;
import org.dflib.series.ArraySeries;
import org.dflib.series.FalseSeries;
import org.dflib.series.FloatArraySeries;
import org.dflib.series.ToString;
import org.dflib.series.TrueSeries;
import org.dflib.series.ValueCounts;
import org.dflib.sort.SeriesSorter;

public abstract class FloatBaseSeries
implements FloatSeries {
    @Override
    public <S> Series<S> castAs(Class<S> type) {
        if (!type.isAssignableFrom(Float.class) && !type.equals(Float.TYPE)) {
            throw new ClassCastException("FloatSeries can not be cast to " + String.valueOf(type));
        }
        return this;
    }

    @Override
    public DataFrame map(Index resultColumns, ValueToRowMapper<Float> mapper) {
        return Mapper.map(this, resultColumns, mapper);
    }

    @Override
    public Series<Float> selectRange(int fromInclusive, int toExclusive) {
        return this.rangeFloat(fromInclusive, toExclusive);
    }

    @Override
    public FloatSeries select(Predicate<Float> p) {
        return this.selectFloat(p::test);
    }

    @Override
    public FloatSeries select(Condition condition) {
        return this.select((BooleanSeries)condition.eval((Series)this));
    }

    @Override
    public FloatSeries select(BooleanSeries positions) {
        int i;
        int len = this.size();
        if (len != positions.size()) {
            throw new IllegalArgumentException("Positions size " + positions.size() + " is not the same as this size " + len);
        }
        for (i = 0; i < len && !positions.getBool(i); ++i) {
        }
        if (i == len) {
            return Series.ofFloat(new float[0]);
        }
        FloatAccum filtered = new FloatAccum(len - i);
        filtered.pushFloat(this.getFloat(i));
        ++i;
        while (i < len) {
            if (positions.getBool(i)) {
                filtered.pushFloat(this.getFloat(i));
            }
            ++i;
        }
        return filtered.toSeries();
    }

    @Override
    public FloatSeries selectFloat(FloatPredicate p) {
        int i;
        int len = this.size();
        for (i = 0; i < len && !p.test(this.getFloat(i)); ++i) {
        }
        if (i == len) {
            return Series.ofFloat(new float[0]);
        }
        FloatAccum filtered = new FloatAccum(len - i);
        filtered.pushFloat(this.getFloat(i));
        ++i;
        while (i < len) {
            float v = this.getFloat(i);
            if (p.test(v)) {
                filtered.pushFloat(v);
            }
            ++i;
        }
        return filtered.toSeries();
    }

    @Override
    public FloatSeries sort(Sorter ... sorters) {
        return this.selectAsFloatSeries(new SeriesSorter<Float>(this).sortIndex(sorters));
    }

    @Override
    public FloatSeries sort(Comparator<? super Float> comparator) {
        return this.selectAsFloatSeries(new SeriesSorter<Float>(this).sortIndex(comparator));
    }

    @Override
    public FloatSeries sortFloat() {
        int size = this.size();
        float[] sorted = new float[size];
        this.copyToFloat(sorted, 0, 0, size);
        Arrays.sort(sorted);
        return new FloatArraySeries(sorted);
    }

    private FloatSeries selectAsFloatSeries(IntSeries positions) {
        int h = positions.size();
        float[] data = new float[h];
        for (int i = 0; i < h; ++i) {
            int index = positions.getInt(i);
            data[i] = this.getFloat(index);
        }
        return new FloatArraySeries(data);
    }

    private Series<Float> selectAsObjectSeries(IntSeries positions) {
        int h = positions.size();
        Float[] data = new Float[h];
        for (int i = 0; i < h; ++i) {
            int index = positions.getInt(i);
            data[i] = index < 0 ? null : Float.valueOf(this.getFloat(index));
        }
        return new ArraySeries<Float>(data);
    }

    @Override
    public FloatSeries concatFloat(FloatSeries ... other) {
        int size;
        if (other.length == 0) {
            return this;
        }
        int h = size = this.size();
        for (FloatSeries s : other) {
            h += s.size();
        }
        float[] data = new float[h];
        this.copyToFloat(data, 0, 0, size);
        int offset = size;
        for (FloatSeries s : other) {
            int len = s.size();
            s.copyToFloat(data, 0, offset, len);
            offset += len;
        }
        return new FloatArraySeries(data);
    }

    @Override
    public Series<Float> fillNulls(Float value) {
        return this;
    }

    @Override
    public Series<Float> fillNullsFromSeries(Series<? extends Float> values) {
        return this;
    }

    @Override
    public Series<Float> fillNullsBackwards() {
        return this;
    }

    @Override
    public Series<Float> fillNullsForward() {
        return this;
    }

    @Override
    @SafeVarargs
    public final Series<Float> concat(Series<? extends Float> ... other) {
        if (other.length == 0) {
            return this;
        }
        Series[] combined = new Series[other.length + 1];
        combined[0] = this;
        System.arraycopy(other, 0, combined, 1, other.length);
        return SeriesConcat.concat(combined);
    }

    @Override
    public void copyTo(Object[] to, int fromOffset, int toOffset, int len) {
        for (int i = 0; i < len; ++i) {
            to[toOffset + i] = Float.valueOf(this.getFloat(fromOffset + i));
        }
    }

    @Override
    public IntSeries indexFloat(FloatPredicate predicate) {
        int len = this.size();
        IntAccum index = new IntAccum(len);
        for (int i = 0; i < len; ++i) {
            if (!predicate.test(this.getFloat(i))) continue;
            index.pushInt(i);
        }
        return index.toSeries();
    }

    @Override
    public IntSeries index(Predicate<Float> predicate) {
        int len = this.size();
        IntAccum index = new IntAccum(len);
        for (int i = 0; i < len; ++i) {
            if (!predicate.test(this.get(i))) continue;
            index.pushInt(i);
        }
        return index.toSeries();
    }

    @Override
    public BooleanSeries locateFloat(FloatPredicate predicate) {
        return BoolBuilder.buildSeries(i -> predicate.test(this.getFloat(i)), this.size());
    }

    @Override
    public Series<Float> replace(Map<Float, Float> oldToNewValues) {
        int len = this.size();
        float[] replaced = new float[len];
        for (int i = 0; i < len; ++i) {
            Float val = Float.valueOf(this.getFloat(i));
            Float newVal = oldToNewValues.getOrDefault(val, val);
            if (newVal == null) {
                return this.replaceAsObjects(oldToNewValues);
            }
            replaced[i] = newVal.floatValue();
        }
        return Series.ofFloat(replaced);
    }

    private Series<Float> replaceAsObjects(Map<Float, Float> oldToNewValues) {
        int len = this.size();
        Float[] replaced = new Float[len];
        for (int i = 0; i < len; ++i) {
            Float val = Float.valueOf(this.getFloat(i));
            replaced[i] = oldToNewValues.getOrDefault(val, val);
        }
        return Series.of(replaced);
    }

    @Override
    public Series<Float> replace(IntSeries positions, Series<Float> with) {
        int rs = positions.size();
        if (rs != with.size()) {
            throw new IllegalArgumentException("Positions size " + rs + " is not the same replacement Series size " + with.size());
        }
        if (rs == 0) {
            return this;
        }
        int s = this.size();
        if (with instanceof FloatSeries) {
            FloatSeries withFloat = (FloatSeries)with;
            FloatAccum values = new FloatAccum(s);
            values.fill(this, 0, 0, s);
            for (int i = 0; i < rs; ++i) {
                values.replace(positions.getInt(i), Float.valueOf(withFloat.getFloat(i)));
            }
            return values.toSeries();
        }
        ObjectAccum<Float> values = new ObjectAccum<Float>(s);
        values.fill(this, 0, 0, s);
        for (int i = 0; i < rs; ++i) {
            values.replace(positions.getInt(i), with.get(i));
        }
        return values.toSeries();
    }

    @Override
    public Series<Float> replace(BooleanSeries condition, Float with) {
        return with != null ? this.replaceFloat(condition, with.floatValue()) : this.nullify(condition);
    }

    @Override
    public Series<Float> replaceExcept(BooleanSeries condition, Float with) {
        return with != null ? this.replaceNoMatchFloat(condition, with.floatValue()) : this.nullifyNoMatch(condition);
    }

    private FloatSeries replaceFloat(BooleanSeries condition, float with) {
        int i;
        int len = this.size();
        int r = Math.min(len, condition.size());
        float[] data = new float[len];
        for (i = 0; i < r; ++i) {
            data[i] = condition.getBool(i) ? with : this.getFloat(i);
        }
        for (i = r; i < len; ++i) {
            data[i] = this.getFloat(i);
        }
        return new FloatArraySeries(data);
    }

    private FloatSeries replaceNoMatchFloat(BooleanSeries condition, float with) {
        int len = this.size();
        int r = Math.min(len, condition.size());
        float[] data = new float[len];
        for (int i = 0; i < r; ++i) {
            data[i] = condition.getBool(i) ? this.getFloat(i) : with;
        }
        if (len > r) {
            Arrays.fill(data, r, len, with);
        }
        return new FloatArraySeries(data);
    }

    private Series<Float> nullify(BooleanSeries condition) {
        int i;
        int len = this.size();
        int r = Math.min(len, condition.size());
        Float[] data = new Float[len];
        for (i = 0; i < r; ++i) {
            data[i] = condition.getBool(i) ? null : Float.valueOf(this.getFloat(i));
        }
        for (i = r; i < len; ++i) {
            data[i] = Float.valueOf(this.getFloat(i));
        }
        return new ArraySeries<Float>(data);
    }

    private Series<Float> nullifyNoMatch(BooleanSeries condition) {
        int len = this.size();
        int r = Math.min(len, condition.size());
        Object[] data = new Float[len];
        for (int i = 0; i < r; ++i) {
            data[i] = condition.getBool(i) ? Float.valueOf(this.getFloat(i)) : null;
        }
        if (len > r) {
            Arrays.fill(data, r, len, null);
        }
        return new ArraySeries<Float>(data);
    }

    @Override
    public BooleanSeries in(Object ... values) {
        int len = this.size();
        if (values == null || values.length == 0) {
            return new FalseSeries(len);
        }
        HashSet<Object> set = new HashSet<Object>();
        for (Object o : values) {
            if (!(o instanceof Float)) continue;
            set.add(o);
        }
        if (set.isEmpty()) {
            return new FalseSeries(len);
        }
        return BoolBuilder.buildSeries(i -> set.contains(this.get(i)), len);
    }

    @Override
    public BooleanSeries notIn(Object ... values) {
        int len = this.size();
        if (values == null || values.length == 0) {
            return new TrueSeries(len);
        }
        HashSet<Object> set = new HashSet<Object>();
        for (Object o : values) {
            if (!(o instanceof Float)) continue;
            set.add(o);
        }
        if (set.isEmpty()) {
            return new TrueSeries(len);
        }
        return BoolBuilder.buildSeries(i -> !set.contains(this.get(i)), len);
    }

    @Override
    public FloatSeries unique() {
        int size = this.size();
        if (size < 2) {
            return this;
        }
        UniqueFloatAccum unique = new UniqueFloatAccum();
        for (int i = 0; i < size; ++i) {
            unique.push(this.get(i));
        }
        return unique.size() < this.size() ? unique.toSeries() : this;
    }

    @Override
    public DataFrame valueCounts() {
        return ValueCounts.valueCountsNoNulls(this);
    }

    @Override
    public SeriesGroupBy<Float> group() {
        return this.group((Float d) -> d);
    }

    @Override
    public SeriesGroupBy<Float> group(ValueMapper<Float, ?> by) {
        return new SeriesGrouper<Float>(by).group(this);
    }

    @Override
    public FloatSeries sample(int size) {
        return this.selectAsFloatSeries(Sampler.sampleIndex(size, this.size()));
    }

    @Override
    public FloatSeries sample(int size, Random random) {
        return this.selectAsFloatSeries(Sampler.sampleIndex(size, this.size(), random));
    }

    public String toString() {
        return ToString.toString(this);
    }
}

