/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import java.util.Arrays;
import org.dflib.BooleanSeries;
import org.dflib.IntSeries;
import org.dflib.series.BooleanBaseSeries;
import org.dflib.series.IntSingleValueSeries;

public class FalseSeries
extends BooleanBaseSeries {
    private final int size;

    public FalseSeries(int size) {
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean getBool(int index) {
        return false;
    }

    @Override
    public void copyToBool(boolean[] to, int fromOffset, int toOffset, int len) {
        Arrays.fill(to, toOffset, toOffset + len, false);
    }

    @Override
    public BooleanSeries materialize() {
        return this;
    }

    @Override
    public BooleanSeries rangeBool(int fromInclusive, int toExclusive) {
        return fromInclusive == 0 && toExclusive == this.size() ? this : new FalseSeries(toExclusive - fromInclusive);
    }

    @Override
    public boolean isFalse() {
        return this.size > 0;
    }

    @Override
    public boolean isTrue() {
        return false;
    }

    @Override
    public int firstTrue() {
        return -1;
    }

    @Override
    public int firstFalse() {
        return this.size > 0 ? 0 : -1;
    }

    @Override
    public int countTrue() {
        return 0;
    }

    @Override
    public int countFalse() {
        return this.size;
    }

    @Override
    public IntSeries cumSum() {
        return new IntSingleValueSeries(0, this.size);
    }
}

