/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import java.util.Arrays;
import org.dflib.DoubleSeries;
import org.dflib.Series;
import org.dflib.agg.PrimitiveSeriesSum;
import org.dflib.range.Range;
import org.dflib.series.DoubleArraySeries;
import org.dflib.series.DoubleBaseSeries;

public class DoubleSingleValueSeries
extends DoubleBaseSeries {
    private final double value;
    private final Double boxedValue;
    private final int size;

    public DoubleSingleValueSeries(double value, int size) {
        this.value = value;
        this.size = size;
        this.boxedValue = value;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Double get(int index) {
        return this.boxedValue;
    }

    @Override
    public double getDouble(int index) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.value;
    }

    @Override
    public void copyToDouble(double[] to, int fromOffset, int toOffset, int len) {
        Arrays.fill(to, toOffset, toOffset + len, this.value);
    }

    @Override
    public DoubleSeries diff(Series<? extends Double> other) {
        if (this.size == 0 || other.size() == 0) {
            return this;
        }
        for (Double d : other) {
            if (d == null || d != this.value) continue;
            return Series.ofDouble(new double[0]);
        }
        return this;
    }

    @Override
    public DoubleSeries intersect(Series<? extends Double> other) {
        if (this.size == 0) {
            return this;
        }
        if (other.size() == 0) {
            return Series.ofDouble(new double[0]);
        }
        for (Double d : other) {
            if (d == null || d != this.value) continue;
            return this;
        }
        return Series.ofDouble(new double[0]);
    }

    @Override
    public DoubleSeries materialize() {
        return this;
    }

    @Override
    public DoubleSeries rangeDouble(int fromInclusive, int toExclusive) {
        if (fromInclusive == 0 && toExclusive == this.size) {
            return this;
        }
        Range.checkRange(fromInclusive, toExclusive - fromInclusive, this.size);
        if (fromInclusive == toExclusive) {
            return new DoubleArraySeries(new double[0]);
        }
        return new DoubleSingleValueSeries(this.value, toExclusive - fromInclusive);
    }

    @Override
    public DoubleSeries cumSum() {
        double[] cumSum = PrimitiveSeriesSum.cumSumOfValue(this.value, this.size);
        return new DoubleArraySeries(cumSum);
    }

    @Override
    public double max() {
        return this.value;
    }

    @Override
    public double min() {
        return this.value;
    }

    @Override
    public double sum() {
        return this.value * (double)this.size;
    }

    @Override
    public double avg() {
        return this.value;
    }

    @Override
    public double median() {
        return this.value;
    }

    @Override
    public double quantile(double q) {
        return this.value;
    }
}

