/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.function.DoublePredicate;
import java.util.function.Predicate;
import org.dflib.BooleanSeries;
import org.dflib.Condition;
import org.dflib.DataFrame;
import org.dflib.DoubleSeries;
import org.dflib.Index;
import org.dflib.IntSeries;
import org.dflib.Series;
import org.dflib.SeriesGroupBy;
import org.dflib.Sorter;
import org.dflib.ValueMapper;
import org.dflib.ValueToRowMapper;
import org.dflib.builder.BoolBuilder;
import org.dflib.builder.DoubleAccum;
import org.dflib.builder.IntAccum;
import org.dflib.builder.ObjectAccum;
import org.dflib.builder.UniqueDoubleAccum;
import org.dflib.concat.SeriesConcat;
import org.dflib.groupby.SeriesGrouper;
import org.dflib.map.Mapper;
import org.dflib.sample.Sampler;
import org.dflib.series.ArraySeries;
import org.dflib.series.DoubleArraySeries;
import org.dflib.series.FalseSeries;
import org.dflib.series.ToString;
import org.dflib.series.TrueSeries;
import org.dflib.series.ValueCounts;
import org.dflib.sort.SeriesSorter;

public abstract class DoubleBaseSeries
implements DoubleSeries {
    @Override
    public <S> Series<S> castAs(Class<S> type) {
        if (!type.isAssignableFrom(Double.class) && !type.equals(Double.TYPE)) {
            throw new ClassCastException("DoubleSeries can not be cast to " + String.valueOf(type));
        }
        return this;
    }

    @Override
    public DataFrame map(Index resultColumns, ValueToRowMapper<Double> mapper) {
        return Mapper.map(this, resultColumns, mapper);
    }

    @Override
    public Series<Double> selectRange(int fromInclusive, int toExclusive) {
        return this.rangeDouble(fromInclusive, toExclusive);
    }

    @Override
    public DoubleSeries select(Predicate<Double> p) {
        return this.selectDouble(p::test);
    }

    @Override
    public DoubleSeries select(Condition condition) {
        return this.select((BooleanSeries)condition.eval((Series)this));
    }

    @Override
    public DoubleSeries select(BooleanSeries positions) {
        int i;
        int len = this.size();
        if (len != positions.size()) {
            throw new IllegalArgumentException("Positions size " + positions.size() + " is not the same as this size " + len);
        }
        for (i = 0; i < len && !positions.getBool(i); ++i) {
        }
        if (i == len) {
            return Series.ofDouble(new double[0]);
        }
        DoubleAccum filtered = new DoubleAccum(len - i);
        filtered.pushDouble(this.getDouble(i));
        ++i;
        while (i < len) {
            if (positions.getBool(i)) {
                filtered.pushDouble(this.getDouble(i));
            }
            ++i;
        }
        return filtered.toSeries();
    }

    @Override
    public DoubleSeries selectDouble(DoublePredicate p) {
        int i;
        int len = this.size();
        for (i = 0; i < len && !p.test(this.getDouble(i)); ++i) {
        }
        if (i == len) {
            return Series.ofDouble(new double[0]);
        }
        DoubleAccum filtered = new DoubleAccum(len - i);
        filtered.pushDouble(this.getDouble(i));
        ++i;
        while (i < len) {
            double v = this.getDouble(i);
            if (p.test(v)) {
                filtered.pushDouble(v);
            }
            ++i;
        }
        return filtered.toSeries();
    }

    @Override
    public DoubleSeries sort(Sorter ... sorters) {
        return this.selectAsDoubleSeries(new SeriesSorter<Double>(this).sortIndex(sorters));
    }

    @Override
    public DoubleSeries sort(Comparator<? super Double> comparator) {
        return this.selectAsDoubleSeries(new SeriesSorter<Double>(this).sortIndex(comparator));
    }

    @Override
    public DoubleSeries sortDouble() {
        int size = this.size();
        double[] sorted = new double[size];
        this.copyToDouble(sorted, 0, 0, size);
        Arrays.sort(sorted);
        return new DoubleArraySeries(sorted);
    }

    private DoubleSeries selectAsDoubleSeries(IntSeries positions) {
        int h = positions.size();
        double[] data = new double[h];
        for (int i = 0; i < h; ++i) {
            int index = positions.getInt(i);
            data[i] = this.getDouble(index);
        }
        return new DoubleArraySeries(data);
    }

    private Series<Double> selectAsObjectSeries(IntSeries positions) {
        int h = positions.size();
        Double[] data = new Double[h];
        for (int i = 0; i < h; ++i) {
            int index = positions.getInt(i);
            data[i] = index < 0 ? null : Double.valueOf(this.getDouble(index));
        }
        return new ArraySeries<Double>(data);
    }

    @Override
    public DoubleSeries concatDouble(DoubleSeries ... other) {
        int size;
        if (other.length == 0) {
            return this;
        }
        int h = size = this.size();
        for (DoubleSeries s : other) {
            h += s.size();
        }
        double[] data = new double[h];
        this.copyToDouble(data, 0, 0, size);
        int offset = size;
        for (DoubleSeries s : other) {
            int len = s.size();
            s.copyToDouble(data, 0, offset, len);
            offset += len;
        }
        return new DoubleArraySeries(data);
    }

    @Override
    public Series<Double> fillNulls(Double value) {
        return this;
    }

    @Override
    public Series<Double> fillNullsFromSeries(Series<? extends Double> values) {
        return this;
    }

    @Override
    public Series<Double> fillNullsBackwards() {
        return this;
    }

    @Override
    public Series<Double> fillNullsForward() {
        return this;
    }

    @Override
    @SafeVarargs
    public final Series<Double> concat(Series<? extends Double> ... other) {
        if (other.length == 0) {
            return this;
        }
        Series[] combined = new Series[other.length + 1];
        combined[0] = this;
        System.arraycopy(other, 0, combined, 1, other.length);
        return SeriesConcat.concat(combined);
    }

    @Override
    public void copyTo(Object[] to, int fromOffset, int toOffset, int len) {
        for (int i = 0; i < len; ++i) {
            to[toOffset + i] = this.getDouble(fromOffset + i);
        }
    }

    @Override
    public IntSeries indexDouble(DoublePredicate predicate) {
        int len = this.size();
        IntAccum index = new IntAccum(len);
        for (int i = 0; i < len; ++i) {
            if (!predicate.test(this.getDouble(i))) continue;
            index.pushInt(i);
        }
        return index.toSeries();
    }

    @Override
    public IntSeries index(Predicate<Double> predicate) {
        int len = this.size();
        IntAccum index = new IntAccum(len);
        for (int i = 0; i < len; ++i) {
            if (!predicate.test(this.get(i))) continue;
            index.pushInt(i);
        }
        return index.toSeries();
    }

    @Override
    public BooleanSeries locateDouble(DoublePredicate predicate) {
        return BoolBuilder.buildSeries(i -> predicate.test(this.getDouble(i)), this.size());
    }

    @Override
    public Series<Double> replace(Map<Double, Double> oldToNewValues) {
        int len = this.size();
        double[] replaced = new double[len];
        for (int i = 0; i < len; ++i) {
            Double val = this.getDouble(i);
            Double newVal = oldToNewValues.getOrDefault(val, val);
            if (newVal == null) {
                return this.replaceAsObjects(oldToNewValues);
            }
            replaced[i] = newVal;
        }
        return Series.ofDouble(replaced);
    }

    private Series<Double> replaceAsObjects(Map<Double, Double> oldToNewValues) {
        int len = this.size();
        Double[] replaced = new Double[len];
        for (int i = 0; i < len; ++i) {
            Double val = this.getDouble(i);
            replaced[i] = oldToNewValues.getOrDefault(val, val);
        }
        return Series.of(replaced);
    }

    @Override
    public Series<Double> replace(IntSeries positions, Series<Double> with) {
        int rs = positions.size();
        if (rs != with.size()) {
            throw new IllegalArgumentException("Positions size " + rs + " is not the same replacement Series size " + with.size());
        }
        if (rs == 0) {
            return this;
        }
        int s = this.size();
        if (with instanceof DoubleSeries) {
            DoubleSeries withDouble = (DoubleSeries)with;
            DoubleAccum values = new DoubleAccum(s);
            values.fill(this, 0, 0, s);
            for (int i = 0; i < rs; ++i) {
                values.replace(positions.getInt(i), withDouble.getDouble(i));
            }
            return values.toSeries();
        }
        ObjectAccum<Double> values = new ObjectAccum<Double>(s);
        values.fill(this, 0, 0, s);
        for (int i = 0; i < rs; ++i) {
            values.replace(positions.getInt(i), with.get(i));
        }
        return values.toSeries();
    }

    @Override
    public Series<Double> replace(BooleanSeries condition, Double with) {
        return with != null ? this.replaceDouble(condition, (double)with) : this.nullify(condition);
    }

    @Override
    public Series<Double> replaceExcept(BooleanSeries condition, Double with) {
        return with != null ? this.replaceNoMatchDouble(condition, with) : this.nullifyNoMatch(condition);
    }

    private DoubleSeries replaceDouble(BooleanSeries condition, double with) {
        int i;
        int len = this.size();
        int r = Math.min(len, condition.size());
        double[] data = new double[len];
        for (i = 0; i < r; ++i) {
            data[i] = condition.getBool(i) ? with : this.getDouble(i);
        }
        for (i = r; i < len; ++i) {
            data[i] = this.getDouble(i);
        }
        return new DoubleArraySeries(data);
    }

    private DoubleSeries replaceNoMatchDouble(BooleanSeries condition, double with) {
        int len = this.size();
        int r = Math.min(len, condition.size());
        double[] data = new double[len];
        for (int i = 0; i < r; ++i) {
            data[i] = condition.getBool(i) ? this.getDouble(i) : with;
        }
        if (len > r) {
            Arrays.fill(data, r, len, with);
        }
        return new DoubleArraySeries(data);
    }

    private Series<Double> nullify(BooleanSeries condition) {
        int i;
        int len = this.size();
        int r = Math.min(len, condition.size());
        Double[] data = new Double[len];
        for (i = 0; i < r; ++i) {
            data[i] = condition.getBool(i) ? null : Double.valueOf(this.getDouble(i));
        }
        for (i = r; i < len; ++i) {
            data[i] = this.getDouble(i);
        }
        return new ArraySeries<Double>(data);
    }

    private Series<Double> nullifyNoMatch(BooleanSeries condition) {
        int len = this.size();
        int r = Math.min(len, condition.size());
        Object[] data = new Double[len];
        for (int i = 0; i < r; ++i) {
            data[i] = condition.getBool(i) ? Double.valueOf(this.getDouble(i)) : null;
        }
        if (len > r) {
            Arrays.fill(data, r, len, null);
        }
        return new ArraySeries<Double>(data);
    }

    @Override
    public BooleanSeries in(Object ... values) {
        int len = this.size();
        if (values == null || values.length == 0) {
            return new FalseSeries(len);
        }
        HashSet<Object> set = new HashSet<Object>();
        for (Object o : values) {
            if (!(o instanceof Double)) continue;
            set.add(o);
        }
        if (set.isEmpty()) {
            return new FalseSeries(len);
        }
        return BoolBuilder.buildSeries(i -> set.contains(this.get(i)), len);
    }

    @Override
    public BooleanSeries notIn(Object ... values) {
        int len = this.size();
        if (values == null || values.length == 0) {
            return new TrueSeries(len);
        }
        HashSet<Object> set = new HashSet<Object>();
        for (Object o : values) {
            if (!(o instanceof Double)) continue;
            set.add(o);
        }
        if (set.isEmpty()) {
            return new TrueSeries(len);
        }
        return BoolBuilder.buildSeries(i -> !set.contains(this.get(i)), len);
    }

    @Override
    public DoubleSeries unique() {
        int size = this.size();
        if (size < 2) {
            return this;
        }
        UniqueDoubleAccum unique = new UniqueDoubleAccum();
        for (int i = 0; i < size; ++i) {
            unique.push(this.get(i));
        }
        return unique.size() < this.size() ? unique.toSeries() : this;
    }

    @Override
    public DataFrame valueCounts() {
        return ValueCounts.valueCountsNoNulls(this);
    }

    @Override
    public SeriesGroupBy<Double> group() {
        return this.group((Double d) -> d);
    }

    @Override
    public SeriesGroupBy<Double> group(ValueMapper<Double, ?> by) {
        return new SeriesGrouper<Double>(by).group(this);
    }

    @Override
    public DoubleSeries sample(int size) {
        return this.selectAsDoubleSeries(Sampler.sampleIndex(size, this.size()));
    }

    @Override
    public DoubleSeries sample(int size, Random random) {
        return this.selectAsDoubleSeries(Sampler.sampleIndex(size, this.size(), random));
    }

    public String toString() {
        return ToString.toString(this);
    }
}

