/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import org.dflib.DoubleSeries;
import org.dflib.agg.Percentiles;
import org.dflib.agg.PrimitiveSeriesAvg;
import org.dflib.agg.PrimitiveSeriesMinMax;
import org.dflib.agg.PrimitiveSeriesSum;
import org.dflib.series.DoubleArrayRangeSeries;
import org.dflib.series.DoubleBaseSeries;

public class DoubleArraySeries
extends DoubleBaseSeries {
    private final double[] data;

    public DoubleArraySeries(double ... data) {
        this.data = data;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public DoubleSeries add(DoubleSeries s) {
        if (!(s instanceof DoubleArraySeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        DoubleArraySeries as = (DoubleArraySeries)s;
        double[] l = this.data;
        double[] r = as.data;
        double[] data = new double[len];
        for (int i = 0; i < len; ++i) {
            data[i] = l[i] + r[i];
        }
        return new DoubleArraySeries(data);
    }

    @Override
    public DoubleSeries sub(DoubleSeries s) {
        if (!(s instanceof DoubleArraySeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        DoubleArraySeries as = (DoubleArraySeries)s;
        double[] l = this.data;
        double[] r = as.data;
        double[] data = new double[len];
        for (int i = 0; i < len; ++i) {
            data[i] = l[i] - r[i];
        }
        return new DoubleArraySeries(data);
    }

    @Override
    public DoubleSeries mul(DoubleSeries s) {
        if (!(s instanceof DoubleArraySeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        DoubleArraySeries as = (DoubleArraySeries)s;
        double[] l = this.data;
        double[] r = as.data;
        double[] data = new double[len];
        for (int i = 0; i < len; ++i) {
            data[i] = l[i] * r[i];
        }
        return new DoubleArraySeries(data);
    }

    @Override
    public DoubleSeries div(DoubleSeries s) {
        if (!(s instanceof DoubleArraySeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        DoubleArraySeries as = (DoubleArraySeries)s;
        double[] l = this.data;
        double[] r = as.data;
        double[] data = new double[len];
        for (int i = 0; i < len; ++i) {
            data[i] = l[i] / r[i];
        }
        return new DoubleArraySeries(data);
    }

    @Override
    public DoubleSeries mod(DoubleSeries s) {
        if (!(s instanceof DoubleArraySeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        DoubleArraySeries as = (DoubleArraySeries)s;
        double[] l = this.data;
        double[] r = as.data;
        double[] data = new double[len];
        for (int i = 0; i < len; ++i) {
            data[i] = l[i] % r[i];
        }
        return new DoubleArraySeries(data);
    }

    @Override
    public double getDouble(int index) {
        return this.data[index];
    }

    @Override
    public void copyToDouble(double[] to, int fromOffset, int toOffset, int len) {
        if (fromOffset + len > this.size()) {
            throw new ArrayIndexOutOfBoundsException(fromOffset + len);
        }
        System.arraycopy(this.data, fromOffset, to, toOffset, len);
    }

    @Override
    public DoubleSeries rangeDouble(int fromInclusive, int toExclusive) {
        return fromInclusive == 0 && toExclusive == this.size() ? this : new DoubleArrayRangeSeries(this.data, fromInclusive, toExclusive - fromInclusive);
    }

    @Override
    public DoubleSeries materialize() {
        return this;
    }

    @Override
    public double max() {
        return PrimitiveSeriesMinMax.maxOfArray(this.data, 0, this.size());
    }

    @Override
    public double min() {
        return PrimitiveSeriesMinMax.minOfArray(this.data, 0, this.size());
    }

    @Override
    public double sum() {
        return PrimitiveSeriesSum.sumOfArray(this.data, 0, this.size());
    }

    @Override
    public double avg() {
        return PrimitiveSeriesAvg.avgOfArray(this.data, 0, this.size());
    }

    @Override
    public double quantile(double q) {
        return Percentiles.ofArray(this.data, 0, this.size(), q);
    }

    @Override
    public DoubleSeries cumSum() {
        double[] cumSum = PrimitiveSeriesSum.cumSumOfArray(this.data, 0, this.size());
        return new DoubleArraySeries(cumSum);
    }
}

