/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import org.dflib.DoubleSeries;
import org.dflib.agg.Percentiles;
import org.dflib.agg.PrimitiveSeriesAvg;
import org.dflib.agg.PrimitiveSeriesMinMax;
import org.dflib.agg.PrimitiveSeriesSum;
import org.dflib.series.DoubleArraySeries;
import org.dflib.series.DoubleBaseSeries;

public class DoubleArrayRangeSeries
extends DoubleBaseSeries {
    private final double[] data;
    private final int offset;
    private final int size;

    public DoubleArrayRangeSeries(double[] data, int offset, int size) {
        this.data = data;
        this.offset = offset;
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public DoubleSeries add(DoubleSeries s) {
        if (!(s instanceof DoubleArrayRangeSeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        DoubleArrayRangeSeries as = (DoubleArrayRangeSeries)s;
        double[] l = this.data;
        double[] r = as.data;
        int lo = this.offset;
        int ro = as.offset;
        double[] data = new double[len];
        if (lo > 0 || ro > 0) {
            for (int i = 0; i < len; ++i) {
                data[i] = l[lo + i] + r[ro + i];
            }
        } else {
            for (int i = 0; i < len; ++i) {
                data[i] = l[i] + r[i];
            }
        }
        return new DoubleArraySeries(data);
    }

    @Override
    public DoubleSeries sub(DoubleSeries s) {
        if (!(s instanceof DoubleArrayRangeSeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        DoubleArrayRangeSeries as = (DoubleArrayRangeSeries)s;
        double[] l = this.data;
        double[] r = as.data;
        int lo = this.offset;
        int ro = as.offset;
        double[] data = new double[len];
        if (lo > 0 || ro > 0) {
            for (int i = 0; i < len; ++i) {
                data[i] = l[lo + i] - r[ro + i];
            }
        } else {
            for (int i = 0; i < len; ++i) {
                data[i] = l[i] - r[i];
            }
        }
        return new DoubleArraySeries(data);
    }

    @Override
    public DoubleSeries mul(DoubleSeries s) {
        if (!(s instanceof DoubleArrayRangeSeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        DoubleArrayRangeSeries as = (DoubleArrayRangeSeries)s;
        double[] l = this.data;
        double[] r = as.data;
        int lo = this.offset;
        int ro = as.offset;
        double[] data = new double[len];
        if (lo > 0 || ro > 0) {
            for (int i = 0; i < len; ++i) {
                data[i] = l[lo + i] * r[ro + i];
            }
        } else {
            for (int i = 0; i < len; ++i) {
                data[i] = l[i] * r[i];
            }
        }
        return new DoubleArraySeries(data);
    }

    @Override
    public DoubleSeries div(DoubleSeries s) {
        if (!(s instanceof DoubleArrayRangeSeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        DoubleArrayRangeSeries as = (DoubleArrayRangeSeries)s;
        double[] l = this.data;
        double[] r = as.data;
        int lo = this.offset;
        int ro = as.offset;
        double[] data = new double[len];
        if (lo > 0 || ro > 0) {
            for (int i = 0; i < len; ++i) {
                data[i] = l[lo + i] / r[ro + i];
            }
        } else {
            for (int i = 0; i < len; ++i) {
                data[i] = l[i] / r[i];
            }
        }
        return new DoubleArraySeries(data);
    }

    @Override
    public DoubleSeries mod(DoubleSeries s) {
        if (!(s instanceof DoubleArrayRangeSeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        DoubleArrayRangeSeries as = (DoubleArrayRangeSeries)s;
        double[] l = this.data;
        double[] r = as.data;
        int lo = this.offset;
        int ro = as.offset;
        double[] data = new double[len];
        if (lo > 0 || ro > 0) {
            for (int i = 0; i < len; ++i) {
                data[i] = l[lo + i] % r[ro + i];
            }
        } else {
            for (int i = 0; i < len; ++i) {
                data[i] = l[i] % r[i];
            }
        }
        return new DoubleArraySeries(data);
    }

    @Override
    public double getDouble(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.data[this.offset + index];
    }

    @Override
    public void copyToDouble(double[] to, int fromOffset, int toOffset, int len) {
        if (fromOffset + len > this.size) {
            throw new ArrayIndexOutOfBoundsException(fromOffset + len);
        }
        System.arraycopy(this.data, this.offset + fromOffset, to, toOffset, len);
    }

    @Override
    public DoubleSeries rangeDouble(int fromInclusive, int toExclusive) {
        return fromInclusive == 0 && toExclusive == this.size() ? this : new DoubleArrayRangeSeries(this.data, this.offset + fromInclusive, toExclusive - fromInclusive);
    }

    @Override
    public DoubleSeries materialize() {
        if (this.offset == 0 && this.size == this.data.length) {
            return new DoubleArraySeries(this.data);
        }
        double[] data = new double[this.size];
        this.copyToDouble(data, 0, 0, this.size);
        return new DoubleArraySeries(data);
    }

    @Override
    public double max() {
        return PrimitiveSeriesMinMax.maxOfArray(this.data, this.offset, this.size);
    }

    @Override
    public double min() {
        return PrimitiveSeriesMinMax.minOfArray(this.data, this.offset, this.size);
    }

    @Override
    public double sum() {
        return PrimitiveSeriesSum.sumOfArray(this.data, this.offset, this.size);
    }

    @Override
    public double avg() {
        return PrimitiveSeriesAvg.avgOfArray(this.data, this.offset, this.size);
    }

    @Override
    public double quantile(double q) {
        return Percentiles.ofArray(this.data, this.offset, this.size, q);
    }

    @Override
    public DoubleSeries cumSum() {
        double[] cumSum = PrimitiveSeriesSum.cumSumOfArray(this.data, this.offset, this.size);
        return new DoubleArraySeries(cumSum);
    }
}

