/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import org.dflib.Series;
import org.dflib.ValueMapper;
import org.dflib.series.ArraySeries;
import org.dflib.series.ObjectSeries;

public class ColumnMappedSeries<S, T>
extends ObjectSeries<T> {
    private Series<S> source;
    private ValueMapper<S, T> mapper;
    private Series<T> materialized;

    public ColumnMappedSeries(Series<S> source, ValueMapper<S, T> mapper) {
        super(Object.class);
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    public int size() {
        return this.source != null ? this.source.size() : this.materialized.size();
    }

    @Override
    public T get(int index) {
        return this.materialize().get(index);
    }

    @Override
    public void copyTo(Object[] to, int fromOffset, int toOffset, int len) {
        this.materialize().copyTo(to, fromOffset, toOffset, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Series<T> materialize() {
        if (this.materialized == null) {
            ColumnMappedSeries columnMappedSeries = this;
            synchronized (columnMappedSeries) {
                if (this.materialized == null) {
                    this.materialized = this.doMaterialize();
                }
            }
        }
        return this.materialized;
    }

    protected ArraySeries<T> doMaterialize() {
        Object[] data = new Object[this.size()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.mapper.map(this.source.get(i));
        }
        this.source = null;
        this.mapper = null;
        return new ArraySeries<Object>(data);
    }

    @Override
    public Series<T> fillNulls(T value) {
        return this.materialize().fillNulls(value);
    }

    @Override
    public Series<T> fillNullsFromSeries(Series<? extends T> values) {
        return this.materialize().fillNullsFromSeries(values);
    }

    @Override
    public Series<T> fillNullsBackwards() {
        return this.materialize().fillNullsBackwards();
    }

    @Override
    public Series<T> fillNullsForward() {
        return this.materialize().fillNullsForward();
    }
}

