/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import java.util.Comparator;
import java.util.function.Predicate;
import org.dflib.BooleanSeries;
import org.dflib.IntSeries;
import org.dflib.Sorter;
import org.dflib.builder.BoolAccum;
import org.dflib.builder.BoolBuilder;
import org.dflib.series.BooleanBaseSeries;
import org.dflib.series.FalseSeries;
import org.dflib.series.IntArraySeries;
import org.dflib.sort.SeriesSorter;

public class BooleanBitsetSeries
extends BooleanBaseSeries {
    private static final int INDEX_BIT_SHIFT = 6;
    private static final long LONG_BITS_MASK = -1L;
    final long[] data;
    private final int size;

    public BooleanBitsetSeries(long[] data, int size) {
        this.data = data;
        this.size = size;
    }

    @Override
    public boolean getBool(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        int i = index >> 6;
        return (this.data[i] & 1L << index) != 0L;
    }

    private boolean getUnchecked(int index) {
        return (this.data[index >> 6] & 1L << index) != 0L;
    }

    @Override
    public void copyToBool(boolean[] to, int fromOffset, int toOffset, int len) {
        if (fromOffset + len > this.size()) {
            throw new ArrayIndexOutOfBoundsException(fromOffset + len);
        }
        for (int i = 0; i < len; ++i) {
            to[toOffset + i] = this.getUnchecked(fromOffset + i);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public BooleanSeries materialize() {
        return this;
    }

    @Override
    public BooleanSeries rangeBool(int fromInclusive, int toExclusive) {
        if (fromInclusive == 0 && toExclusive == this.size()) {
            return this;
        }
        if (this.size <= fromInclusive || fromInclusive == toExclusive) {
            return new FalseSeries(0);
        }
        if (toExclusive > this.size) {
            toExclusive = this.size;
        }
        int resultSize = BooleanBitsetSeries.arraySize(toExclusive - fromInclusive);
        int setSize = toExclusive - fromInclusive;
        long[] result = new long[resultSize];
        int startIndex = fromInclusive >> 6;
        boolean indexAligned = (fromInclusive & 0x3F) == 0;
        int i = 0;
        while (i < resultSize - 1) {
            result[i] = indexAligned ? this.data[startIndex] : this.data[startIndex] >>> fromInclusive | this.data[startIndex + 1] << -fromInclusive;
            ++i;
            ++startIndex;
        }
        long lastElementMask = -1L >>> -toExclusive;
        result[resultSize - 1] = (toExclusive - 1 & 0x3F) < (fromInclusive & 0x3F) ? this.data[startIndex] >>> fromInclusive | (this.data[startIndex + 1] & lastElementMask) << -fromInclusive : (this.data[startIndex] & lastElementMask) >>> fromInclusive;
        return new BooleanBitsetSeries(result, setSize);
    }

    @Override
    public BooleanSeries select(Predicate<Boolean> p) {
        return this.selectAsBooleanSeries(this.index(p));
    }

    @Override
    public BooleanSeries select(BooleanSeries positions) {
        int len = positions.size();
        if (this.size != positions.size()) {
            throw new IllegalArgumentException("Positions size " + positions.size() + " is not the same as this size " + len);
        }
        int firstTrue = this.firstTrue();
        BoolAccum accum = new BoolAccum(len - firstTrue);
        if (positions instanceof BooleanBitsetSeries) {
            BooleanBitsetSeries bitPositions = (BooleanBitsetSeries)positions;
            for (int i = 0; i < this.data.length; ++i) {
                long pos = bitPositions.data[i];
                long val = this.data[i];
                for (int j = 0; j < 64; ++j) {
                    long mask = 1L << j;
                    if ((pos & mask) == 0L) continue;
                    accum.pushBool((val & mask) != 0L);
                }
            }
        } else {
            for (int i = firstTrue; i < len; ++i) {
                if (!positions.getBool(i)) continue;
                accum.pushBool(this.getUnchecked(i));
            }
        }
        return accum.toSeries();
    }

    @Override
    public BooleanSeries concatBool(BooleanSeries ... other) {
        int size;
        if (other.length == 0) {
            return this;
        }
        int h = size = this.size();
        for (BooleanSeries s : other) {
            if (!(s instanceof BooleanBitsetSeries)) {
                return super.concatBool(other);
            }
            h += s.size();
        }
        long[] result = new long[BooleanBitsetSeries.arraySize(h)];
        System.arraycopy(this.data, 0, result, 0, this.data.length);
        int currentSizeInBits = size;
        for (BooleanSeries s : other) {
            BooleanBitsetSeries nextBitsetSeries = (BooleanBitsetSeries)s;
            int bitsLeft = nextBitsetSeries.size();
            for (long nextLong : nextBitsetSeries.data) {
                int nextIndex = BooleanBitsetSeries.arraySize(currentSizeInBits);
                int n = nextIndex - 1;
                result[n] = result[n] | nextLong << currentSizeInBits;
                if (nextIndex < result.length) {
                    int n2 = nextIndex;
                    result[n2] = result[n2] | nextLong >>> -currentSizeInBits;
                }
                currentSizeInBits += Math.min(bitsLeft, 64);
                bitsLeft -= 64;
            }
        }
        return new BooleanBitsetSeries(result, h);
    }

    @Override
    public BooleanSeries sort(Sorter ... sorters) {
        return this.selectAsBooleanSeries(new SeriesSorter<Boolean>(this).sortIndex(sorters));
    }

    @Override
    public BooleanSeries sort(Comparator<? super Boolean> comparator) {
        return this.selectAsBooleanSeries(new SeriesSorter<Boolean>(this).sortIndex(comparator));
    }

    private BooleanSeries selectAsBooleanSeries(IntSeries positions) {
        return BoolBuilder.buildSeries(i -> this.getUnchecked(positions.getInt(i)), positions.size());
    }

    @Override
    public int firstTrue() {
        for (int i = 0; i < this.data.length; ++i) {
            long next = this.data[i];
            if (next == 0L) continue;
            int index = Long.numberOfTrailingZeros(next);
            int realIndex = (i << 6) + index;
            return realIndex < this.size ? realIndex : -1;
        }
        return -1;
    }

    @Override
    public int firstFalse() {
        for (int i = 0; i < this.data.length; ++i) {
            long next = this.data[i];
            if (next == 0L) {
                return i << 6;
            }
            if (next == -1L) continue;
            int index = Long.numberOfTrailingZeros(next ^ 0xFFFFFFFFFFFFFFFFL);
            int realIndex = (i << 6) + index;
            return realIndex < this.size ? realIndex : -1;
        }
        return -1;
    }

    @Override
    public BooleanSeries and(BooleanSeries another) {
        if (another instanceof BooleanBitsetSeries) {
            if (another.size() != this.size()) {
                throw new IllegalArgumentException("Argument differ in size");
            }
            long[] newData = new long[this.data.length];
            for (int i = 0; i < this.data.length; ++i) {
                newData[i] = this.data[i] & ((BooleanBitsetSeries)another).data[i];
            }
            return new BooleanBitsetSeries(newData, this.size);
        }
        return super.and(another);
    }

    @Override
    public BooleanSeries or(BooleanSeries another) {
        if (another instanceof BooleanBitsetSeries) {
            if (another.size() != this.size()) {
                throw new IllegalArgumentException("Argument differ in size");
            }
            long[] newData = new long[this.data.length];
            for (int i = 0; i < this.data.length; ++i) {
                newData[i] = this.data[i] | ((BooleanBitsetSeries)another).data[i];
            }
            return new BooleanBitsetSeries(newData, this.size);
        }
        return super.or(another);
    }

    @Override
    public BooleanBitsetSeries not() {
        long[] newData = new long[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            newData[i] = this.data[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return new BooleanBitsetSeries(newData, this.size);
    }

    @Override
    public int countTrue() {
        int count = 0;
        for (long next : this.data) {
            if (next == 0L) continue;
            count += Long.bitCount(next);
        }
        return count;
    }

    @Override
    public int countFalse() {
        int count = this.size;
        for (long next : this.data) {
            if (next == 0L) continue;
            count -= Long.bitCount(next);
        }
        return count;
    }

    @Override
    public IntSeries cumSum() {
        int[] cumSum = new int[this.size];
        int s = 0;
        for (int i = 0; i < this.size; ++i) {
            cumSum[i] = s += this.getBool(i) ? 1 : 0;
        }
        return new IntArraySeries(cumSum);
    }

    private static int arraySize(int setSize) {
        return 1 + (setSize - 1 >> 6);
    }
}

